/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandMeshVertexMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshVertexBufferMSFT
extends Struct<XrHandMeshVertexBufferMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEXUPDATETIME;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTICES;

    protected XrHandMeshVertexBufferMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandMeshVertexBufferMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrHandMeshVertexBufferMSFT(address, container);
    }

    public XrHandMeshVertexBufferMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandMeshVertexBufferMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrTime")
    public long vertexUpdateTime() {
        return XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrHandMeshVertexBufferMSFT.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="XrHandMeshVertexMSFT *")
    public XrHandMeshVertexMSFT.Buffer vertices() {
        return XrHandMeshVertexBufferMSFT.nvertices(this.address());
    }

    public XrHandMeshVertexBufferMSFT vertexUpdateTime(@NativeType(value="XrTime") long value) {
        XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrHandMeshVertexBufferMSFT.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT vertices(@Nullable @NativeType(value="XrHandMeshVertexMSFT *") XrHandMeshVertexMSFT.Buffer value) {
        XrHandMeshVertexBufferMSFT.nvertices(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT set(long vertexUpdateTime, int vertexCapacityInput, int vertexCountOutput, @Nullable XrHandMeshVertexMSFT.Buffer vertices) {
        this.vertexUpdateTime(vertexUpdateTime);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertices(vertices);
        return this;
    }

    public XrHandMeshVertexBufferMSFT set(XrHandMeshVertexBufferMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandMeshVertexBufferMSFT malloc() {
        return new XrHandMeshVertexBufferMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandMeshVertexBufferMSFT calloc() {
        return new XrHandMeshVertexBufferMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandMeshVertexBufferMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandMeshVertexBufferMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandMeshVertexBufferMSFT create(long address) {
        return new XrHandMeshVertexBufferMSFT(address, null);
    }

    @Nullable
    public static XrHandMeshVertexBufferMSFT createSafe(long address) {
        return address == 0L ? null : new XrHandMeshVertexBufferMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandMeshVertexBufferMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshVertexBufferMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandMeshVertexBufferMSFT malloc(MemoryStack stack) {
        return new XrHandMeshVertexBufferMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandMeshVertexBufferMSFT calloc(MemoryStack stack) {
        return new XrHandMeshVertexBufferMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvertexUpdateTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)VERTEXUPDATETIME);
    }

    public static int nvertexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNTOUTPUT);
    }

    @Nullable
    public static XrHandMeshVertexMSFT.Buffer nvertices(long struct) {
        return XrHandMeshVertexMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)VERTICES)), XrHandMeshVertexBufferMSFT.nvertexCapacityInput(struct));
    }

    public static void nvertexUpdateTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VERTEXUPDATETIME, value);
    }

    public static void nvertexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertices(long struct, @Nullable XrHandMeshVertexMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTICES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrHandMeshVertexBufferMSFT.nvertexCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrHandMeshVertexBufferMSFT.__struct((Struct.Member[])new Struct.Member[]{XrHandMeshVertexBufferMSFT.__member((int)8), XrHandMeshVertexBufferMSFT.__member((int)4), XrHandMeshVertexBufferMSFT.__member((int)4), XrHandMeshVertexBufferMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEXUPDATETIME = layout.offsetof(0);
        VERTEXCAPACITYINPUT = layout.offsetof(1);
        VERTEXCOUNTOUTPUT = layout.offsetof(2);
        VERTICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshVertexBufferMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshVertexBufferMSFT ELEMENT_FACTORY = XrHandMeshVertexBufferMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandMeshVertexBufferMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrTime")
        public long vertexUpdateTime() {
            return XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrHandMeshVertexBufferMSFT.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="XrHandMeshVertexMSFT *")
        public XrHandMeshVertexMSFT.Buffer vertices() {
            return XrHandMeshVertexBufferMSFT.nvertices(this.address());
        }

        public Buffer vertexUpdateTime(@NativeType(value="XrTime") long value) {
            XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrHandMeshVertexBufferMSFT.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertices(@Nullable @NativeType(value="XrHandMeshVertexMSFT *") XrHandMeshVertexMSFT.Buffer value) {
            XrHandMeshVertexBufferMSFT.nvertices(this.address(), value);
            return this;
        }
    }
}

