/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingDataSourceInfoEXT
extends Struct<XrHandTrackingDataSourceInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int REQUESTEDDATASOURCECOUNT;
    public static final int REQUESTEDDATASOURCES;

    protected XrHandTrackingDataSourceInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandTrackingDataSourceInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingDataSourceInfoEXT(address, container);
    }

    public XrHandTrackingDataSourceInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandTrackingDataSourceInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingDataSourceInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHandTrackingDataSourceInfoEXT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int requestedDataSourceCount() {
        return XrHandTrackingDataSourceInfoEXT.nrequestedDataSourceCount(this.address());
    }

    @Nullable
    @NativeType(value="XrHandTrackingDataSourceEXT *")
    public IntBuffer requestedDataSources() {
        return XrHandTrackingDataSourceInfoEXT.nrequestedDataSources(this.address());
    }

    public XrHandTrackingDataSourceInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingDataSourceInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingDataSourceInfoEXT type$Default() {
        return this.type(1000428000);
    }

    public XrHandTrackingDataSourceInfoEXT next(@NativeType(value="void const *") long value) {
        XrHandTrackingDataSourceInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingDataSourceInfoEXT requestedDataSources(@Nullable @NativeType(value="XrHandTrackingDataSourceEXT *") IntBuffer value) {
        XrHandTrackingDataSourceInfoEXT.nrequestedDataSources(this.address(), value);
        return this;
    }

    public XrHandTrackingDataSourceInfoEXT set(int type, long next, @Nullable IntBuffer requestedDataSources) {
        this.type(type);
        this.next(next);
        this.requestedDataSources(requestedDataSources);
        return this;
    }

    public XrHandTrackingDataSourceInfoEXT set(XrHandTrackingDataSourceInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandTrackingDataSourceInfoEXT malloc() {
        return new XrHandTrackingDataSourceInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandTrackingDataSourceInfoEXT calloc() {
        return new XrHandTrackingDataSourceInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandTrackingDataSourceInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandTrackingDataSourceInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandTrackingDataSourceInfoEXT create(long address) {
        return new XrHandTrackingDataSourceInfoEXT(address, null);
    }

    @Nullable
    public static XrHandTrackingDataSourceInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingDataSourceInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandTrackingDataSourceInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingDataSourceInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingDataSourceInfoEXT malloc(MemoryStack stack) {
        return new XrHandTrackingDataSourceInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingDataSourceInfoEXT calloc(MemoryStack stack) {
        return new XrHandTrackingDataSourceInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nrequestedDataSourceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REQUESTEDDATASOURCECOUNT);
    }

    @Nullable
    public static IntBuffer nrequestedDataSources(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)REQUESTEDDATASOURCES)), (int)XrHandTrackingDataSourceInfoEXT.nrequestedDataSourceCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nrequestedDataSourceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REQUESTEDDATASOURCECOUNT, value);
    }

    public static void nrequestedDataSources(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REQUESTEDDATASOURCES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        XrHandTrackingDataSourceInfoEXT.nrequestedDataSourceCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (XrHandTrackingDataSourceInfoEXT.nrequestedDataSourceCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REQUESTEDDATASOURCES)));
        }
    }

    static {
        Struct.Layout layout = XrHandTrackingDataSourceInfoEXT.__struct((Struct.Member[])new Struct.Member[]{XrHandTrackingDataSourceInfoEXT.__member((int)4), XrHandTrackingDataSourceInfoEXT.__member((int)POINTER_SIZE), XrHandTrackingDataSourceInfoEXT.__member((int)4), XrHandTrackingDataSourceInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        REQUESTEDDATASOURCECOUNT = layout.offsetof(2);
        REQUESTEDDATASOURCES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingDataSourceInfoEXT, Buffer>
    implements NativeResource {
        private static final XrHandTrackingDataSourceInfoEXT ELEMENT_FACTORY = XrHandTrackingDataSourceInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandTrackingDataSourceInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingDataSourceInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHandTrackingDataSourceInfoEXT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int requestedDataSourceCount() {
            return XrHandTrackingDataSourceInfoEXT.nrequestedDataSourceCount(this.address());
        }

        @Nullable
        @NativeType(value="XrHandTrackingDataSourceEXT *")
        public IntBuffer requestedDataSources() {
            return XrHandTrackingDataSourceInfoEXT.nrequestedDataSources(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingDataSourceInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000428000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHandTrackingDataSourceInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer requestedDataSources(@Nullable @NativeType(value="XrHandTrackingDataSourceEXT *") IntBuffer value) {
            XrHandTrackingDataSourceInfoEXT.nrequestedDataSources(this.address(), value);
            return this;
        }
    }
}

