/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrLocalizationMapML
extends Struct<XrLocalizationMapML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NAME;
    public static final int MAPUUID;
    public static final int MAPTYPE;

    protected XrLocalizationMapML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrLocalizationMapML create(long address, @Nullable ByteBuffer container) {
        return new XrLocalizationMapML(address, container);
    }

    public XrLocalizationMapML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrLocalizationMapML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrLocalizationMapML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrLocalizationMapML.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
    public ByteBuffer name() {
        return XrLocalizationMapML.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
    public String nameString() {
        return XrLocalizationMapML.nnameString(this.address());
    }

    public XrUuidEXT mapUuid() {
        return XrLocalizationMapML.nmapUuid(this.address());
    }

    @NativeType(value="XrLocalizationMapTypeML")
    public int mapType() {
        return XrLocalizationMapML.nmapType(this.address());
    }

    public XrLocalizationMapML type(@NativeType(value="XrStructureType") int value) {
        XrLocalizationMapML.ntype(this.address(), value);
        return this;
    }

    public XrLocalizationMapML type$Default() {
        return this.type(1000139000);
    }

    public XrLocalizationMapML next(@NativeType(value="void *") long value) {
        XrLocalizationMapML.nnext(this.address(), value);
        return this;
    }

    public XrLocalizationMapML name(@NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]") ByteBuffer value) {
        XrLocalizationMapML.nname(this.address(), value);
        return this;
    }

    public XrLocalizationMapML mapUuid(XrUuidEXT value) {
        XrLocalizationMapML.nmapUuid(this.address(), value);
        return this;
    }

    public XrLocalizationMapML mapUuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.mapUuid());
        return this;
    }

    public XrLocalizationMapML mapType(@NativeType(value="XrLocalizationMapTypeML") int value) {
        XrLocalizationMapML.nmapType(this.address(), value);
        return this;
    }

    public XrLocalizationMapML set(int type, long next, ByteBuffer name, XrUuidEXT mapUuid, int mapType) {
        this.type(type);
        this.next(next);
        this.name(name);
        this.mapUuid(mapUuid);
        this.mapType(mapType);
        return this;
    }

    public XrLocalizationMapML set(XrLocalizationMapML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrLocalizationMapML malloc() {
        return new XrLocalizationMapML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrLocalizationMapML calloc() {
        return new XrLocalizationMapML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrLocalizationMapML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrLocalizationMapML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrLocalizationMapML create(long address) {
        return new XrLocalizationMapML(address, null);
    }

    @Nullable
    public static XrLocalizationMapML createSafe(long address) {
        return address == 0L ? null : new XrLocalizationMapML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrLocalizationMapML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrLocalizationMapML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrLocalizationMapML malloc(MemoryStack stack) {
        return new XrLocalizationMapML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrLocalizationMapML calloc(MemoryStack stack) {
        return new XrLocalizationMapML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)64);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)NAME));
    }

    public static XrUuidEXT nmapUuid(long struct) {
        return XrUuidEXT.create(struct + (long)MAPUUID);
    }

    public static int nmapType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAPTYPE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)NAME), (long)value.remaining());
    }

    public static void nmapUuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MAPUUID), (long)XrUuidEXT.SIZEOF);
    }

    public static void nmapType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAPTYPE, value);
    }

    static {
        Struct.Layout layout = XrLocalizationMapML.__struct((Struct.Member[])new Struct.Member[]{XrLocalizationMapML.__member((int)4), XrLocalizationMapML.__member((int)POINTER_SIZE), XrLocalizationMapML.__array((int)1, (int)64), XrLocalizationMapML.__member((int)XrUuidEXT.SIZEOF, (int)XrUuidEXT.ALIGNOF), XrLocalizationMapML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NAME = layout.offsetof(2);
        MAPUUID = layout.offsetof(3);
        MAPTYPE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrLocalizationMapML, Buffer>
    implements NativeResource {
        private static final XrLocalizationMapML ELEMENT_FACTORY = XrLocalizationMapML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrLocalizationMapML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrLocalizationMapML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrLocalizationMapML.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
        public ByteBuffer name() {
            return XrLocalizationMapML.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
        public String nameString() {
            return XrLocalizationMapML.nnameString(this.address());
        }

        public XrUuidEXT mapUuid() {
            return XrLocalizationMapML.nmapUuid(this.address());
        }

        @NativeType(value="XrLocalizationMapTypeML")
        public int mapType() {
            return XrLocalizationMapML.nmapType(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrLocalizationMapML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000139000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrLocalizationMapML.nnext(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]") ByteBuffer value) {
            XrLocalizationMapML.nname(this.address(), value);
            return this;
        }

        public Buffer mapUuid(XrUuidEXT value) {
            XrLocalizationMapML.nmapUuid(this.address(), value);
            return this;
        }

        public Buffer mapUuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.mapUuid());
            return this;
        }

        public Buffer mapType(@NativeType(value="XrLocalizationMapTypeML") int value) {
            XrLocalizationMapML.nmapType(this.address(), value);
            return this;
        }
    }
}

