/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorArucoInfoML
extends Struct<XrMarkerDetectorArucoInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ARUCODICT;

    protected XrMarkerDetectorArucoInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrMarkerDetectorArucoInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorArucoInfoML(address, container);
    }

    public XrMarkerDetectorArucoInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrMarkerDetectorArucoInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorArucoInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorArucoInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerArucoDictML")
    public int arucoDict() {
        return XrMarkerDetectorArucoInfoML.narucoDict(this.address());
    }

    public XrMarkerDetectorArucoInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorArucoInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorArucoInfoML type$Default() {
        return this.type(1000138002);
    }

    public XrMarkerDetectorArucoInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorArucoInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorArucoInfoML arucoDict(@NativeType(value="XrMarkerArucoDictML") int value) {
        XrMarkerDetectorArucoInfoML.narucoDict(this.address(), value);
        return this;
    }

    public XrMarkerDetectorArucoInfoML set(int type, long next, int arucoDict) {
        this.type(type);
        this.next(next);
        this.arucoDict(arucoDict);
        return this;
    }

    public XrMarkerDetectorArucoInfoML set(XrMarkerDetectorArucoInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrMarkerDetectorArucoInfoML malloc() {
        return new XrMarkerDetectorArucoInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrMarkerDetectorArucoInfoML calloc() {
        return new XrMarkerDetectorArucoInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrMarkerDetectorArucoInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrMarkerDetectorArucoInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrMarkerDetectorArucoInfoML create(long address) {
        return new XrMarkerDetectorArucoInfoML(address, null);
    }

    @Nullable
    public static XrMarkerDetectorArucoInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorArucoInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrMarkerDetectorArucoInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorArucoInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorArucoInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorArucoInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorArucoInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorArucoInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int narucoDict(long struct) {
        return UNSAFE.getInt(null, struct + (long)ARUCODICT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void narucoDict(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ARUCODICT, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorArucoInfoML.__struct((Struct.Member[])new Struct.Member[]{XrMarkerDetectorArucoInfoML.__member((int)4), XrMarkerDetectorArucoInfoML.__member((int)POINTER_SIZE), XrMarkerDetectorArucoInfoML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ARUCODICT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorArucoInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorArucoInfoML ELEMENT_FACTORY = XrMarkerDetectorArucoInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrMarkerDetectorArucoInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorArucoInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorArucoInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerArucoDictML")
        public int arucoDict() {
            return XrMarkerDetectorArucoInfoML.narucoDict(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorArucoInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorArucoInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer arucoDict(@NativeType(value="XrMarkerArucoDictML") int value) {
            XrMarkerDetectorArucoInfoML.narucoDict(this.address(), value);
            return this;
        }
    }
}

