/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrMarkerDetectorAprilTagInfoML;
import org.lwjgl.openxr.XrMarkerDetectorArucoInfoML;
import org.lwjgl.openxr.XrMarkerDetectorCustomProfileInfoML;
import org.lwjgl.openxr.XrMarkerDetectorSizeInfoML;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorCreateInfoML
extends Struct<XrMarkerDetectorCreateInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PROFILE;
    public static final int MARKERTYPE;

    protected XrMarkerDetectorCreateInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrMarkerDetectorCreateInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorCreateInfoML(address, container);
    }

    public XrMarkerDetectorCreateInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrMarkerDetectorCreateInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorCreateInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorCreateInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerDetectorProfileML")
    public int profile() {
        return XrMarkerDetectorCreateInfoML.nprofile(this.address());
    }

    @NativeType(value="XrMarkerTypeML")
    public int markerType() {
        return XrMarkerDetectorCreateInfoML.nmarkerType(this.address());
    }

    public XrMarkerDetectorCreateInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorCreateInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCreateInfoML type$Default() {
        return this.type(1000138001);
    }

    public XrMarkerDetectorCreateInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorCreateInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCreateInfoML next(XrMarkerDetectorAprilTagInfoML value) {
        return this.next(value.next(this.next()).address());
    }

    public XrMarkerDetectorCreateInfoML next(XrMarkerDetectorArucoInfoML value) {
        return this.next(value.next(this.next()).address());
    }

    public XrMarkerDetectorCreateInfoML next(XrMarkerDetectorCustomProfileInfoML value) {
        return this.next(value.next(this.next()).address());
    }

    public XrMarkerDetectorCreateInfoML next(XrMarkerDetectorSizeInfoML value) {
        return this.next(value.next(this.next()).address());
    }

    public XrMarkerDetectorCreateInfoML profile(@NativeType(value="XrMarkerDetectorProfileML") int value) {
        XrMarkerDetectorCreateInfoML.nprofile(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCreateInfoML markerType(@NativeType(value="XrMarkerTypeML") int value) {
        XrMarkerDetectorCreateInfoML.nmarkerType(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCreateInfoML set(int type, long next, int profile, int markerType) {
        this.type(type);
        this.next(next);
        this.profile(profile);
        this.markerType(markerType);
        return this;
    }

    public XrMarkerDetectorCreateInfoML set(XrMarkerDetectorCreateInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrMarkerDetectorCreateInfoML malloc() {
        return new XrMarkerDetectorCreateInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrMarkerDetectorCreateInfoML calloc() {
        return new XrMarkerDetectorCreateInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrMarkerDetectorCreateInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrMarkerDetectorCreateInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrMarkerDetectorCreateInfoML create(long address) {
        return new XrMarkerDetectorCreateInfoML(address, null);
    }

    @Nullable
    public static XrMarkerDetectorCreateInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorCreateInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrMarkerDetectorCreateInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorCreateInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorCreateInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorCreateInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorCreateInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorCreateInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nprofile(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROFILE);
    }

    public static int nmarkerType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MARKERTYPE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nprofile(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROFILE, value);
    }

    public static void nmarkerType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MARKERTYPE, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorCreateInfoML.__struct((Struct.Member[])new Struct.Member[]{XrMarkerDetectorCreateInfoML.__member((int)4), XrMarkerDetectorCreateInfoML.__member((int)POINTER_SIZE), XrMarkerDetectorCreateInfoML.__member((int)4), XrMarkerDetectorCreateInfoML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PROFILE = layout.offsetof(2);
        MARKERTYPE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorCreateInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorCreateInfoML ELEMENT_FACTORY = XrMarkerDetectorCreateInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrMarkerDetectorCreateInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorCreateInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorCreateInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerDetectorProfileML")
        public int profile() {
            return XrMarkerDetectorCreateInfoML.nprofile(this.address());
        }

        @NativeType(value="XrMarkerTypeML")
        public int markerType() {
            return XrMarkerDetectorCreateInfoML.nmarkerType(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorCreateInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorCreateInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrMarkerDetectorAprilTagInfoML value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrMarkerDetectorArucoInfoML value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrMarkerDetectorCustomProfileInfoML value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrMarkerDetectorSizeInfoML value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer profile(@NativeType(value="XrMarkerDetectorProfileML") int value) {
            XrMarkerDetectorCreateInfoML.nprofile(this.address(), value);
            return this;
        }

        public Buffer markerType(@NativeType(value="XrMarkerTypeML") int value) {
            XrMarkerDetectorCreateInfoML.nmarkerType(this.address(), value);
            return this;
        }
    }
}

