/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPlaneDetectorLocationEXT
extends Struct<XrPlaneDetectorLocationEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PLANEID;
    public static final int LOCATIONFLAGS;
    public static final int POSE;
    public static final int EXTENTS;
    public static final int ORIENTATION;
    public static final int SEMANTICTYPE;
    public static final int POLYGONBUFFERCOUNT;

    protected XrPlaneDetectorLocationEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrPlaneDetectorLocationEXT create(long address, @Nullable ByteBuffer container) {
        return new XrPlaneDetectorLocationEXT(address, container);
    }

    public XrPlaneDetectorLocationEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPlaneDetectorLocationEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPlaneDetectorLocationEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrPlaneDetectorLocationEXT.nnext(this.address());
    }

    @NativeType(value="uint64_t")
    public long planeId() {
        return XrPlaneDetectorLocationEXT.nplaneId(this.address());
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrPlaneDetectorLocationEXT.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrPlaneDetectorLocationEXT.npose(this.address());
    }

    public XrExtent2Df extents() {
        return XrPlaneDetectorLocationEXT.nextents(this.address());
    }

    @NativeType(value="XrPlaneDetectorOrientationEXT")
    public int orientation() {
        return XrPlaneDetectorLocationEXT.norientation(this.address());
    }

    @NativeType(value="XrPlaneDetectorSemanticTypeEXT")
    public int semanticType() {
        return XrPlaneDetectorLocationEXT.nsemanticType(this.address());
    }

    @NativeType(value="uint32_t")
    public int polygonBufferCount() {
        return XrPlaneDetectorLocationEXT.npolygonBufferCount(this.address());
    }

    public XrPlaneDetectorLocationEXT type(@NativeType(value="XrStructureType") int value) {
        XrPlaneDetectorLocationEXT.ntype(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT type$Default() {
        return this.type(1000429005);
    }

    public XrPlaneDetectorLocationEXT next(@NativeType(value="void *") long value) {
        XrPlaneDetectorLocationEXT.nnext(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT planeId(@NativeType(value="uint64_t") long value) {
        XrPlaneDetectorLocationEXT.nplaneId(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrPlaneDetectorLocationEXT.nlocationFlags(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT pose(XrPosef value) {
        XrPlaneDetectorLocationEXT.npose(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrPlaneDetectorLocationEXT extents(XrExtent2Df value) {
        XrPlaneDetectorLocationEXT.nextents(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT extents(Consumer<XrExtent2Df> consumer) {
        consumer.accept(this.extents());
        return this;
    }

    public XrPlaneDetectorLocationEXT orientation(@NativeType(value="XrPlaneDetectorOrientationEXT") int value) {
        XrPlaneDetectorLocationEXT.norientation(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT semanticType(@NativeType(value="XrPlaneDetectorSemanticTypeEXT") int value) {
        XrPlaneDetectorLocationEXT.nsemanticType(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT polygonBufferCount(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorLocationEXT.npolygonBufferCount(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationEXT set(int type, long next, long planeId, long locationFlags, XrPosef pose, XrExtent2Df extents, int orientation, int semanticType, int polygonBufferCount) {
        this.type(type);
        this.next(next);
        this.planeId(planeId);
        this.locationFlags(locationFlags);
        this.pose(pose);
        this.extents(extents);
        this.orientation(orientation);
        this.semanticType(semanticType);
        this.polygonBufferCount(polygonBufferCount);
        return this;
    }

    public XrPlaneDetectorLocationEXT set(XrPlaneDetectorLocationEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPlaneDetectorLocationEXT malloc() {
        return new XrPlaneDetectorLocationEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrPlaneDetectorLocationEXT calloc() {
        return new XrPlaneDetectorLocationEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrPlaneDetectorLocationEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrPlaneDetectorLocationEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrPlaneDetectorLocationEXT create(long address) {
        return new XrPlaneDetectorLocationEXT(address, null);
    }

    @Nullable
    public static XrPlaneDetectorLocationEXT createSafe(long address) {
        return address == 0L ? null : new XrPlaneDetectorLocationEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrPlaneDetectorLocationEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPlaneDetectorLocationEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPlaneDetectorLocationEXT malloc(MemoryStack stack) {
        return new XrPlaneDetectorLocationEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPlaneDetectorLocationEXT calloc(MemoryStack stack) {
        return new XrPlaneDetectorLocationEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nplaneId(long struct) {
        return UNSAFE.getLong(null, struct + (long)PLANEID);
    }

    public static long nlocationFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrExtent2Df nextents(long struct) {
        return XrExtent2Df.create(struct + (long)EXTENTS);
    }

    public static int norientation(long struct) {
        return UNSAFE.getInt(null, struct + (long)ORIENTATION);
    }

    public static int nsemanticType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEMANTICTYPE);
    }

    public static int npolygonBufferCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)POLYGONBUFFERCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nplaneId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PLANEID, value);
    }

    public static void nlocationFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LOCATIONFLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nextents(long struct, XrExtent2Df value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENTS), (long)XrExtent2Df.SIZEOF);
    }

    public static void norientation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ORIENTATION, value);
    }

    public static void nsemanticType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SEMANTICTYPE, value);
    }

    public static void npolygonBufferCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)POLYGONBUFFERCOUNT, value);
    }

    static {
        Struct.Layout layout = XrPlaneDetectorLocationEXT.__struct((Struct.Member[])new Struct.Member[]{XrPlaneDetectorLocationEXT.__member((int)4), XrPlaneDetectorLocationEXT.__member((int)POINTER_SIZE), XrPlaneDetectorLocationEXT.__member((int)8), XrPlaneDetectorLocationEXT.__member((int)8), XrPlaneDetectorLocationEXT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrPlaneDetectorLocationEXT.__member((int)XrExtent2Df.SIZEOF, (int)XrExtent2Df.ALIGNOF), XrPlaneDetectorLocationEXT.__member((int)4), XrPlaneDetectorLocationEXT.__member((int)4), XrPlaneDetectorLocationEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PLANEID = layout.offsetof(2);
        LOCATIONFLAGS = layout.offsetof(3);
        POSE = layout.offsetof(4);
        EXTENTS = layout.offsetof(5);
        ORIENTATION = layout.offsetof(6);
        SEMANTICTYPE = layout.offsetof(7);
        POLYGONBUFFERCOUNT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<XrPlaneDetectorLocationEXT, Buffer>
    implements NativeResource {
        private static final XrPlaneDetectorLocationEXT ELEMENT_FACTORY = XrPlaneDetectorLocationEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrPlaneDetectorLocationEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPlaneDetectorLocationEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrPlaneDetectorLocationEXT.nnext(this.address());
        }

        @NativeType(value="uint64_t")
        public long planeId() {
            return XrPlaneDetectorLocationEXT.nplaneId(this.address());
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrPlaneDetectorLocationEXT.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrPlaneDetectorLocationEXT.npose(this.address());
        }

        public XrExtent2Df extents() {
            return XrPlaneDetectorLocationEXT.nextents(this.address());
        }

        @NativeType(value="XrPlaneDetectorOrientationEXT")
        public int orientation() {
            return XrPlaneDetectorLocationEXT.norientation(this.address());
        }

        @NativeType(value="XrPlaneDetectorSemanticTypeEXT")
        public int semanticType() {
            return XrPlaneDetectorLocationEXT.nsemanticType(this.address());
        }

        @NativeType(value="uint32_t")
        public int polygonBufferCount() {
            return XrPlaneDetectorLocationEXT.npolygonBufferCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPlaneDetectorLocationEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000429005);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrPlaneDetectorLocationEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer planeId(@NativeType(value="uint64_t") long value) {
            XrPlaneDetectorLocationEXT.nplaneId(this.address(), value);
            return this;
        }

        public Buffer locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrPlaneDetectorLocationEXT.nlocationFlags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrPlaneDetectorLocationEXT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer extents(XrExtent2Df value) {
            XrPlaneDetectorLocationEXT.nextents(this.address(), value);
            return this;
        }

        public Buffer extents(Consumer<XrExtent2Df> consumer) {
            consumer.accept(this.extents());
            return this;
        }

        public Buffer orientation(@NativeType(value="XrPlaneDetectorOrientationEXT") int value) {
            XrPlaneDetectorLocationEXT.norientation(this.address(), value);
            return this;
        }

        public Buffer semanticType(@NativeType(value="XrPlaneDetectorSemanticTypeEXT") int value) {
            XrPlaneDetectorLocationEXT.nsemanticType(this.address(), value);
            return this;
        }

        public Buffer polygonBufferCount(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorLocationEXT.npolygonBufferCount(this.address(), value);
            return this;
        }
    }
}

