/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrOffset2Df;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect2Df
extends Struct<XrRect2Df>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    protected XrRect2Df(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrRect2Df create(long address, @Nullable ByteBuffer container) {
        return new XrRect2Df(address, container);
    }

    public XrRect2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRect2Df.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset2Df offset() {
        return XrRect2Df.noffset(this.address());
    }

    public XrExtent2Df extent() {
        return XrRect2Df.nextent(this.address());
    }

    public XrRect2Df offset(XrOffset2Df value) {
        XrRect2Df.noffset(this.address(), value);
        return this;
    }

    public XrRect2Df offset(Consumer<XrOffset2Df> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect2Df extent(XrExtent2Df value) {
        XrRect2Df.nextent(this.address(), value);
        return this;
    }

    public XrRect2Df extent(Consumer<XrExtent2Df> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect2Df set(XrOffset2Df offset, XrExtent2Df extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect2Df set(XrRect2Df src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRect2Df malloc() {
        return new XrRect2Df(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrRect2Df calloc() {
        return new XrRect2Df(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrRect2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrRect2Df(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrRect2Df create(long address) {
        return new XrRect2Df(address, null);
    }

    @Nullable
    public static XrRect2Df createSafe(long address) {
        return address == 0L ? null : new XrRect2Df(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrRect2Df.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect2Df.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRect2Df malloc(MemoryStack stack) {
        return new XrRect2Df(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRect2Df calloc(MemoryStack stack) {
        return new XrRect2Df(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrOffset2Df noffset(long struct) {
        return XrOffset2Df.create(struct + (long)OFFSET);
    }

    public static XrExtent2Df nextent(long struct) {
        return XrExtent2Df.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset2Df value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)XrOffset2Df.SIZEOF);
    }

    public static void nextent(long struct, XrExtent2Df value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)XrExtent2Df.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect2Df.__struct((Struct.Member[])new Struct.Member[]{XrRect2Df.__member((int)XrOffset2Df.SIZEOF, (int)XrOffset2Df.ALIGNOF), XrRect2Df.__member((int)XrExtent2Df.SIZEOF, (int)XrExtent2Df.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect2Df, Buffer>
    implements NativeResource {
        private static final XrRect2Df ELEMENT_FACTORY = XrRect2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrRect2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset2Df offset() {
            return XrRect2Df.noffset(this.address());
        }

        public XrExtent2Df extent() {
            return XrRect2Df.nextent(this.address());
        }

        public Buffer offset(XrOffset2Df value) {
            XrRect2Df.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset2Df> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent2Df value) {
            XrRect2Df.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent2Df> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

