/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelPathInfoFB
extends Struct<XrRenderModelPathInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PATH;

    protected XrRenderModelPathInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrRenderModelPathInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrRenderModelPathInfoFB(address, container);
    }

    public XrRenderModelPathInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRenderModelPathInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelPathInfoFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelPathInfoFB.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long path() {
        return XrRenderModelPathInfoFB.npath(this.address());
    }

    public XrRenderModelPathInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelPathInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelPathInfoFB type$Default() {
        return this.type(1000119000);
    }

    public XrRenderModelPathInfoFB next(@NativeType(value="void *") long value) {
        XrRenderModelPathInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelPathInfoFB path(@NativeType(value="XrPath") long value) {
        XrRenderModelPathInfoFB.npath(this.address(), value);
        return this;
    }

    public XrRenderModelPathInfoFB set(int type, long next, long path) {
        this.type(type);
        this.next(next);
        this.path(path);
        return this;
    }

    public XrRenderModelPathInfoFB set(XrRenderModelPathInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRenderModelPathInfoFB malloc() {
        return new XrRenderModelPathInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrRenderModelPathInfoFB calloc() {
        return new XrRenderModelPathInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrRenderModelPathInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrRenderModelPathInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrRenderModelPathInfoFB create(long address) {
        return new XrRenderModelPathInfoFB(address, null);
    }

    @Nullable
    public static XrRenderModelPathInfoFB createSafe(long address) {
        return address == 0L ? null : new XrRenderModelPathInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrRenderModelPathInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelPathInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRenderModelPathInfoFB malloc(MemoryStack stack) {
        return new XrRenderModelPathInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRenderModelPathInfoFB calloc(MemoryStack stack) {
        return new XrRenderModelPathInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long npath(long struct) {
        return UNSAFE.getLong(null, struct + (long)PATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void npath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PATH, value);
    }

    static {
        Struct.Layout layout = XrRenderModelPathInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrRenderModelPathInfoFB.__member((int)4), XrRenderModelPathInfoFB.__member((int)POINTER_SIZE), XrRenderModelPathInfoFB.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PATH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelPathInfoFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelPathInfoFB ELEMENT_FACTORY = XrRenderModelPathInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrRenderModelPathInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelPathInfoFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelPathInfoFB.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long path() {
            return XrRenderModelPathInfoFB.npath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelPathInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelPathInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer path(@NativeType(value="XrPath") long value) {
            XrRenderModelPathInfoFB.npath(this.address(), value);
            return this;
        }
    }
}

