/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrOffset2Df;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMarkerMSFT
extends Struct<XrSceneMarkerMSFT> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MARKERTYPE;
    public static final int LASTSEENTIME;
    public static final int CENTER;
    public static final int SIZE;

    protected XrSceneMarkerMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneMarkerMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneMarkerMSFT(address, container);
    }

    public XrSceneMarkerMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneMarkerMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSceneMarkerTypeMSFT")
    public int markerType() {
        return XrSceneMarkerMSFT.nmarkerType(this.address());
    }

    @NativeType(value="XrTime")
    public long lastSeenTime() {
        return XrSceneMarkerMSFT.nlastSeenTime(this.address());
    }

    public XrOffset2Df center() {
        return XrSceneMarkerMSFT.ncenter(this.address());
    }

    public XrExtent2Df size() {
        return XrSceneMarkerMSFT.nsize(this.address());
    }

    public static XrSceneMarkerMSFT create(long address) {
        return new XrSceneMarkerMSFT(address, null);
    }

    @Nullable
    public static XrSceneMarkerMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneMarkerMSFT(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nmarkerType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MARKERTYPE);
    }

    public static long nlastSeenTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)LASTSEENTIME);
    }

    public static XrOffset2Df ncenter(long struct) {
        return XrOffset2Df.create(struct + (long)CENTER);
    }

    public static XrExtent2Df nsize(long struct) {
        return XrExtent2Df.create(struct + (long)SIZE);
    }

    static {
        Struct.Layout layout = XrSceneMarkerMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneMarkerMSFT.__member((int)4), XrSceneMarkerMSFT.__member((int)8), XrSceneMarkerMSFT.__member((int)XrOffset2Df.SIZEOF, (int)XrOffset2Df.ALIGNOF), XrSceneMarkerMSFT.__member((int)XrExtent2Df.SIZEOF, (int)XrExtent2Df.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MARKERTYPE = layout.offsetof(0);
        LASTSEENTIME = layout.offsetof(1);
        CENTER = layout.offsetof(2);
        SIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMarkerMSFT, Buffer> {
        private static final XrSceneMarkerMSFT ELEMENT_FACTORY = XrSceneMarkerMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneMarkerMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSceneMarkerTypeMSFT")
        public int markerType() {
            return XrSceneMarkerMSFT.nmarkerType(this.address());
        }

        @NativeType(value="XrTime")
        public long lastSeenTime() {
            return XrSceneMarkerMSFT.nlastSeenTime(this.address());
        }

        public XrOffset2Df center() {
            return XrSceneMarkerMSFT.ncenter(this.address());
        }

        public XrExtent2Df size() {
            return XrSceneMarkerMSFT.nsize(this.address());
        }
    }
}

