/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneMarkerMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMarkersMSFT
extends Struct<XrSceneMarkersMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SCENEMARKERCAPACITYINPUT;
    public static final int SCENEMARKERS;

    protected XrSceneMarkersMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneMarkersMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneMarkersMSFT(address, container);
    }

    public XrSceneMarkersMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneMarkersMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMarkersMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneMarkersMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int sceneMarkerCapacityInput() {
        return XrSceneMarkersMSFT.nsceneMarkerCapacityInput(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneMarkerMSFT *")
    public XrSceneMarkerMSFT.Buffer sceneMarkers() {
        return XrSceneMarkersMSFT.nsceneMarkers(this.address());
    }

    public XrSceneMarkersMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMarkersMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMarkersMSFT type$Default() {
        return this.type(1000147000);
    }

    public XrSceneMarkersMSFT next(@NativeType(value="void const *") long value) {
        XrSceneMarkersMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMarkersMSFT sceneMarkerCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSceneMarkersMSFT.nsceneMarkerCapacityInput(this.address(), value);
        return this;
    }

    public XrSceneMarkersMSFT sceneMarkers(@Nullable @NativeType(value="XrSceneMarkerMSFT *") XrSceneMarkerMSFT.Buffer value) {
        XrSceneMarkersMSFT.nsceneMarkers(this.address(), value);
        return this;
    }

    public XrSceneMarkersMSFT set(int type, long next, int sceneMarkerCapacityInput, @Nullable XrSceneMarkerMSFT.Buffer sceneMarkers) {
        this.type(type);
        this.next(next);
        this.sceneMarkerCapacityInput(sceneMarkerCapacityInput);
        this.sceneMarkers(sceneMarkers);
        return this;
    }

    public XrSceneMarkersMSFT set(XrSceneMarkersMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneMarkersMSFT malloc() {
        return new XrSceneMarkersMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneMarkersMSFT calloc() {
        return new XrSceneMarkersMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneMarkersMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneMarkersMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneMarkersMSFT create(long address) {
        return new XrSceneMarkersMSFT(address, null);
    }

    @Nullable
    public static XrSceneMarkersMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneMarkersMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneMarkersMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMarkersMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneMarkersMSFT malloc(MemoryStack stack) {
        return new XrSceneMarkersMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneMarkersMSFT calloc(MemoryStack stack) {
        return new XrSceneMarkersMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nsceneMarkerCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)SCENEMARKERCAPACITYINPUT);
    }

    @Nullable
    public static XrSceneMarkerMSFT.Buffer nsceneMarkers(long struct) {
        return XrSceneMarkerMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SCENEMARKERS)), XrSceneMarkersMSFT.nsceneMarkerCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsceneMarkerCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SCENEMARKERCAPACITYINPUT, value);
    }

    public static void nsceneMarkers(long struct, @Nullable XrSceneMarkerMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SCENEMARKERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneMarkersMSFT.nsceneMarkerCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneMarkersMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneMarkersMSFT.__member((int)4), XrSceneMarkersMSFT.__member((int)POINTER_SIZE), XrSceneMarkersMSFT.__member((int)4), XrSceneMarkersMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SCENEMARKERCAPACITYINPUT = layout.offsetof(2);
        SCENEMARKERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMarkersMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMarkersMSFT ELEMENT_FACTORY = XrSceneMarkersMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneMarkersMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMarkersMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneMarkersMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int sceneMarkerCapacityInput() {
            return XrSceneMarkersMSFT.nsceneMarkerCapacityInput(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneMarkerMSFT *")
        public XrSceneMarkerMSFT.Buffer sceneMarkers() {
            return XrSceneMarkersMSFT.nsceneMarkers(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMarkersMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000147000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneMarkersMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer sceneMarkerCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSceneMarkersMSFT.nsceneMarkerCapacityInput(this.address(), value);
            return this;
        }

        public Buffer sceneMarkers(@Nullable @NativeType(value="XrSceneMarkerMSFT *") XrSceneMarkerMSFT.Buffer value) {
            XrSceneMarkersMSFT.nsceneMarkers(this.address(), value);
            return this;
        }
    }
}

