/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshBuffersMSFT
extends Struct<XrSceneMeshBuffersMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSceneMeshBuffersMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneMeshBuffersMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneMeshBuffersMSFT(address, container);
    }

    public XrSceneMeshBuffersMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneMeshBuffersMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMeshBuffersMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneMeshBuffersMSFT.nnext(this.address());
    }

    public XrSceneMeshBuffersMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMeshBuffersMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT type$Default() {
        return this.type(1000097015);
    }

    public XrSceneMeshBuffersMSFT next(@NativeType(value="void *") long value) {
        XrSceneMeshBuffersMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(XrSceneMeshBuffersMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneMeshBuffersMSFT malloc() {
        return new XrSceneMeshBuffersMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneMeshBuffersMSFT calloc() {
        return new XrSceneMeshBuffersMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneMeshBuffersMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneMeshBuffersMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneMeshBuffersMSFT create(long address) {
        return new XrSceneMeshBuffersMSFT(address, null);
    }

    @Nullable
    public static XrSceneMeshBuffersMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneMeshBuffersMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneMeshBuffersMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshBuffersMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneMeshBuffersMSFT malloc(MemoryStack stack) {
        return new XrSceneMeshBuffersMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneMeshBuffersMSFT calloc(MemoryStack stack) {
        return new XrSceneMeshBuffersMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSceneMeshBuffersMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneMeshBuffersMSFT.__member((int)4), XrSceneMeshBuffersMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshBuffersMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshBuffersMSFT ELEMENT_FACTORY = XrSceneMeshBuffersMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneMeshBuffersMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMeshBuffersMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneMeshBuffersMSFT.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMeshBuffersMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097015);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneMeshBuffersMSFT.nnext(this.address(), value);
            return this;
        }
    }
}

