/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshMSFT
extends Struct<XrSceneMeshMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MESHBUFFERID;
    public static final int SUPPORTSINDICESUINT16;

    protected XrSceneMeshMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneMeshMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneMeshMSFT(address, container);
    }

    public XrSceneMeshMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneMeshMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long meshBufferId() {
        return XrSceneMeshMSFT.nmeshBufferId(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsIndicesUint16() {
        return XrSceneMeshMSFT.nsupportsIndicesUint16(this.address()) != 0;
    }

    public XrSceneMeshMSFT meshBufferId(@NativeType(value="uint64_t") long value) {
        XrSceneMeshMSFT.nmeshBufferId(this.address(), value);
        return this;
    }

    public XrSceneMeshMSFT supportsIndicesUint16(@NativeType(value="XrBool32") boolean value) {
        XrSceneMeshMSFT.nsupportsIndicesUint16(this.address(), value ? 1 : 0);
        return this;
    }

    public XrSceneMeshMSFT set(long meshBufferId, boolean supportsIndicesUint16) {
        this.meshBufferId(meshBufferId);
        this.supportsIndicesUint16(supportsIndicesUint16);
        return this;
    }

    public XrSceneMeshMSFT set(XrSceneMeshMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneMeshMSFT malloc() {
        return new XrSceneMeshMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneMeshMSFT calloc() {
        return new XrSceneMeshMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneMeshMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneMeshMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneMeshMSFT create(long address) {
        return new XrSceneMeshMSFT(address, null);
    }

    @Nullable
    public static XrSceneMeshMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneMeshMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneMeshMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneMeshMSFT malloc(MemoryStack stack) {
        return new XrSceneMeshMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneMeshMSFT calloc(MemoryStack stack) {
        return new XrSceneMeshMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmeshBufferId(long struct) {
        return UNSAFE.getLong(null, struct + (long)MESHBUFFERID);
    }

    public static int nsupportsIndicesUint16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSINDICESUINT16);
    }

    public static void nmeshBufferId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MESHBUFFERID, value);
    }

    public static void nsupportsIndicesUint16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTSINDICESUINT16, value);
    }

    static {
        Struct.Layout layout = XrSceneMeshMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneMeshMSFT.__member((int)8), XrSceneMeshMSFT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MESHBUFFERID = layout.offsetof(0);
        SUPPORTSINDICESUINT16 = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshMSFT ELEMENT_FACTORY = XrSceneMeshMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneMeshMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long meshBufferId() {
            return XrSceneMeshMSFT.nmeshBufferId(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsIndicesUint16() {
            return XrSceneMeshMSFT.nsupportsIndicesUint16(this.address()) != 0;
        }

        public Buffer meshBufferId(@NativeType(value="uint64_t") long value) {
            XrSceneMeshMSFT.nmeshBufferId(this.address(), value);
            return this;
        }

        public Buffer supportsIndicesUint16(@NativeType(value="XrBool32") boolean value) {
            XrSceneMeshMSFT.nsupportsIndicesUint16(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

