/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrScenePlaneMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrScenePlanesMSFT
extends Struct<XrScenePlanesMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SCENEPLANECOUNT;
    public static final int SCENEPLANES;

    protected XrScenePlanesMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrScenePlanesMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrScenePlanesMSFT(address, container);
    }

    public XrScenePlanesMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrScenePlanesMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrScenePlanesMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrScenePlanesMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int scenePlaneCount() {
        return XrScenePlanesMSFT.nscenePlaneCount(this.address());
    }

    @Nullable
    @NativeType(value="XrScenePlaneMSFT *")
    public XrScenePlaneMSFT.Buffer scenePlanes() {
        return XrScenePlanesMSFT.nscenePlanes(this.address());
    }

    public XrScenePlanesMSFT type(@NativeType(value="XrStructureType") int value) {
        XrScenePlanesMSFT.ntype(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT type$Default() {
        return this.type(1000097011);
    }

    public XrScenePlanesMSFT next(@NativeType(value="void *") long value) {
        XrScenePlanesMSFT.nnext(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT scenePlaneCount(@NativeType(value="uint32_t") int value) {
        XrScenePlanesMSFT.nscenePlaneCount(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT scenePlanes(@Nullable @NativeType(value="XrScenePlaneMSFT *") XrScenePlaneMSFT.Buffer value) {
        XrScenePlanesMSFT.nscenePlanes(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT set(int type, long next, int scenePlaneCount, @Nullable XrScenePlaneMSFT.Buffer scenePlanes) {
        this.type(type);
        this.next(next);
        this.scenePlaneCount(scenePlaneCount);
        this.scenePlanes(scenePlanes);
        return this;
    }

    public XrScenePlanesMSFT set(XrScenePlanesMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrScenePlanesMSFT malloc() {
        return new XrScenePlanesMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrScenePlanesMSFT calloc() {
        return new XrScenePlanesMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrScenePlanesMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrScenePlanesMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrScenePlanesMSFT create(long address) {
        return new XrScenePlanesMSFT(address, null);
    }

    @Nullable
    public static XrScenePlanesMSFT createSafe(long address) {
        return address == 0L ? null : new XrScenePlanesMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrScenePlanesMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrScenePlanesMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrScenePlanesMSFT malloc(MemoryStack stack) {
        return new XrScenePlanesMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrScenePlanesMSFT calloc(MemoryStack stack) {
        return new XrScenePlanesMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nscenePlaneCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SCENEPLANECOUNT);
    }

    @Nullable
    public static XrScenePlaneMSFT.Buffer nscenePlanes(long struct) {
        return XrScenePlaneMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SCENEPLANES)), XrScenePlanesMSFT.nscenePlaneCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nscenePlaneCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SCENEPLANECOUNT, value);
    }

    public static void nscenePlanes(long struct, @Nullable XrScenePlaneMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SCENEPLANES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrScenePlanesMSFT.nscenePlaneCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrScenePlanesMSFT.__struct((Struct.Member[])new Struct.Member[]{XrScenePlanesMSFT.__member((int)4), XrScenePlanesMSFT.__member((int)POINTER_SIZE), XrScenePlanesMSFT.__member((int)4), XrScenePlanesMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SCENEPLANECOUNT = layout.offsetof(2);
        SCENEPLANES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrScenePlanesMSFT, Buffer>
    implements NativeResource {
        private static final XrScenePlanesMSFT ELEMENT_FACTORY = XrScenePlanesMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrScenePlanesMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrScenePlanesMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrScenePlanesMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int scenePlaneCount() {
            return XrScenePlanesMSFT.nscenePlaneCount(this.address());
        }

        @Nullable
        @NativeType(value="XrScenePlaneMSFT *")
        public XrScenePlaneMSFT.Buffer scenePlanes() {
            return XrScenePlanesMSFT.nscenePlanes(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrScenePlanesMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097011);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrScenePlanesMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer scenePlaneCount(@NativeType(value="uint32_t") int value) {
            XrScenePlanesMSFT.nscenePlaneCount(this.address(), value);
            return this;
        }

        public Buffer scenePlanes(@Nullable @NativeType(value="XrScenePlaneMSFT *") XrScenePlaneMSFT.Buffer value) {
            XrScenePlanesMSFT.nscenePlanes(this.address(), value);
            return this;
        }
    }
}

