/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceLocationData
extends Struct<XrSpaceLocationData> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATIONFLAGS;
    public static final int POSE;

    protected XrSpaceLocationData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceLocationData create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceLocationData(address, container);
    }

    public XrSpaceLocationData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceLocationData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrSpaceLocationData.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrSpaceLocationData.npose(this.address());
    }

    public static XrSpaceLocationData create(long address) {
        return new XrSpaceLocationData(address, null);
    }

    @Nullable
    public static XrSpaceLocationData createSafe(long address) {
        return address == 0L ? null : new XrSpaceLocationData(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nlocationFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    static {
        Struct.Layout layout = XrSpaceLocationData.__struct((Struct.Member[])new Struct.Member[]{XrSpaceLocationData.__member((int)8), XrSpaceLocationData.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATIONFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceLocationData, Buffer> {
        private static final XrSpaceLocationData ELEMENT_FACTORY = XrSpaceLocationData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceLocationData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrSpaceLocationData.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrSpaceLocationData.npose(this.address());
        }
    }
}

