/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceLocationData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrSpaceLocationDataKHR
extends XrSpaceLocationData {
    protected XrSpaceLocationDataKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceLocationDataKHR create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceLocationDataKHR(address, container);
    }

    public XrSpaceLocationDataKHR(ByteBuffer container) {
        super(container);
    }

    public static XrSpaceLocationDataKHR malloc() {
        return new XrSpaceLocationDataKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpaceLocationDataKHR calloc() {
        return new XrSpaceLocationDataKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpaceLocationDataKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpaceLocationDataKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpaceLocationDataKHR create(long address) {
        return new XrSpaceLocationDataKHR(address, null);
    }

    @Nullable
    public static XrSpaceLocationDataKHR createSafe(long address) {
        return address == 0L ? null : new XrSpaceLocationDataKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpaceLocationDataKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceLocationDataKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceLocationDataKHR malloc(MemoryStack stack) {
        return new XrSpaceLocationDataKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceLocationDataKHR calloc(MemoryStack stack) {
        return new XrSpaceLocationDataKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrSpaceLocationData.Buffer {
        private static final XrSpaceLocationDataKHR ELEMENT_FACTORY = XrSpaceLocationDataKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSpaceLocationDataKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

