/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceLocationData;
import org.lwjgl.openxr.XrSpaceVelocities;
import org.lwjgl.openxr.XrSpaceVelocitiesKHR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceLocations
extends Struct<XrSpaceLocations>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONCOUNT;
    public static final int LOCATIONS;

    protected XrSpaceLocations(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceLocations create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceLocations(address, container);
    }

    public XrSpaceLocations(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceLocations.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceLocations.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpaceLocations.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int locationCount() {
        return XrSpaceLocations.nlocationCount(this.address());
    }

    @NativeType(value="XrSpaceLocationData *")
    public XrSpaceLocationData.Buffer locations() {
        return XrSpaceLocations.nlocations(this.address());
    }

    public XrSpaceLocations type(@NativeType(value="XrStructureType") int value) {
        XrSpaceLocations.ntype(this.address(), value);
        return this;
    }

    public XrSpaceLocations type$Default() {
        return this.type(1000471001);
    }

    public XrSpaceLocations next(@NativeType(value="void *") long value) {
        XrSpaceLocations.nnext(this.address(), value);
        return this;
    }

    public XrSpaceLocations next(XrSpaceVelocities value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSpaceLocations next(XrSpaceVelocitiesKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSpaceLocations locations(@NativeType(value="XrSpaceLocationData *") XrSpaceLocationData.Buffer value) {
        XrSpaceLocations.nlocations(this.address(), value);
        return this;
    }

    public XrSpaceLocations set(int type, long next, XrSpaceLocationData.Buffer locations) {
        this.type(type);
        this.next(next);
        this.locations(locations);
        return this;
    }

    public XrSpaceLocations set(XrSpaceLocations src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceLocations malloc() {
        return new XrSpaceLocations(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpaceLocations calloc() {
        return new XrSpaceLocations(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpaceLocations create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpaceLocations(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpaceLocations create(long address) {
        return new XrSpaceLocations(address, null);
    }

    @Nullable
    public static XrSpaceLocations createSafe(long address) {
        return address == 0L ? null : new XrSpaceLocations(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpaceLocations.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceLocations.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceLocations malloc(MemoryStack stack) {
        return new XrSpaceLocations(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceLocations calloc(MemoryStack stack) {
        return new XrSpaceLocations(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nlocationCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATIONCOUNT);
    }

    public static XrSpaceLocationData.Buffer nlocations(long struct) {
        return XrSpaceLocationData.create(MemoryUtil.memGetAddress((long)(struct + (long)LOCATIONS)), XrSpaceLocations.nlocationCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlocationCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATIONCOUNT, value);
    }

    public static void nlocations(long struct, XrSpaceLocationData.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LOCATIONS), (long)value.address());
        XrSpaceLocations.nlocationCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)LOCATIONS)));
    }

    static {
        Struct.Layout layout = XrSpaceLocations.__struct((Struct.Member[])new Struct.Member[]{XrSpaceLocations.__member((int)4), XrSpaceLocations.__member((int)POINTER_SIZE), XrSpaceLocations.__member((int)4), XrSpaceLocations.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONCOUNT = layout.offsetof(2);
        LOCATIONS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceLocations, Buffer>
    implements NativeResource {
        private static final XrSpaceLocations ELEMENT_FACTORY = XrSpaceLocations.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceLocations getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceLocations.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpaceLocations.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int locationCount() {
            return XrSpaceLocations.nlocationCount(this.address());
        }

        @NativeType(value="XrSpaceLocationData *")
        public XrSpaceLocationData.Buffer locations() {
            return XrSpaceLocations.nlocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceLocations.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000471001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceLocations.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSpaceVelocities value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSpaceVelocitiesKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer locations(@NativeType(value="XrSpaceLocationData *") XrSpaceLocationData.Buffer value) {
            XrSpaceLocations.nlocations(this.address(), value);
            return this;
        }
    }
}

