/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceVelocityData;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceVelocities
extends Struct<XrSpaceVelocities>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VELOCITYCOUNT;
    public static final int VELOCITIES;

    protected XrSpaceVelocities(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceVelocities create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceVelocities(address, container);
    }

    public XrSpaceVelocities(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceVelocities.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceVelocities.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpaceVelocities.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int velocityCount() {
        return XrSpaceVelocities.nvelocityCount(this.address());
    }

    @NativeType(value="XrSpaceVelocityData *")
    public XrSpaceVelocityData.Buffer velocities() {
        return XrSpaceVelocities.nvelocities(this.address());
    }

    public XrSpaceVelocities type(@NativeType(value="XrStructureType") int value) {
        XrSpaceVelocities.ntype(this.address(), value);
        return this;
    }

    public XrSpaceVelocities type$Default() {
        return this.type(1000471002);
    }

    public XrSpaceVelocities next(@NativeType(value="void *") long value) {
        XrSpaceVelocities.nnext(this.address(), value);
        return this;
    }

    public XrSpaceVelocities velocities(@NativeType(value="XrSpaceVelocityData *") XrSpaceVelocityData.Buffer value) {
        XrSpaceVelocities.nvelocities(this.address(), value);
        return this;
    }

    public XrSpaceVelocities set(int type, long next, XrSpaceVelocityData.Buffer velocities) {
        this.type(type);
        this.next(next);
        this.velocities(velocities);
        return this;
    }

    public XrSpaceVelocities set(XrSpaceVelocities src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceVelocities malloc() {
        return new XrSpaceVelocities(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpaceVelocities calloc() {
        return new XrSpaceVelocities(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpaceVelocities create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpaceVelocities(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpaceVelocities create(long address) {
        return new XrSpaceVelocities(address, null);
    }

    @Nullable
    public static XrSpaceVelocities createSafe(long address) {
        return address == 0L ? null : new XrSpaceVelocities(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpaceVelocities.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceVelocities.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceVelocities malloc(MemoryStack stack) {
        return new XrSpaceVelocities(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceVelocities calloc(MemoryStack stack) {
        return new XrSpaceVelocities(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nvelocityCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VELOCITYCOUNT);
    }

    public static XrSpaceVelocityData.Buffer nvelocities(long struct) {
        return XrSpaceVelocityData.create(MemoryUtil.memGetAddress((long)(struct + (long)VELOCITIES)), XrSpaceVelocities.nvelocityCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nvelocityCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VELOCITYCOUNT, value);
    }

    public static void nvelocities(long struct, XrSpaceVelocityData.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VELOCITIES), (long)value.address());
        XrSpaceVelocities.nvelocityCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VELOCITIES)));
    }

    static {
        Struct.Layout layout = XrSpaceVelocities.__struct((Struct.Member[])new Struct.Member[]{XrSpaceVelocities.__member((int)4), XrSpaceVelocities.__member((int)POINTER_SIZE), XrSpaceVelocities.__member((int)4), XrSpaceVelocities.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VELOCITYCOUNT = layout.offsetof(2);
        VELOCITIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceVelocities, Buffer>
    implements NativeResource {
        private static final XrSpaceVelocities ELEMENT_FACTORY = XrSpaceVelocities.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceVelocities getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceVelocities.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpaceVelocities.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int velocityCount() {
            return XrSpaceVelocities.nvelocityCount(this.address());
        }

        @NativeType(value="XrSpaceVelocityData *")
        public XrSpaceVelocityData.Buffer velocities() {
            return XrSpaceVelocities.nvelocities(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceVelocities.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000471002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceVelocities.nnext(this.address(), value);
            return this;
        }

        public Buffer velocities(@NativeType(value="XrSpaceVelocityData *") XrSpaceVelocityData.Buffer value) {
            XrSpaceVelocities.nvelocities(this.address(), value);
            return this;
        }
    }
}

