/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceVelocityData
extends Struct<XrSpaceVelocityData> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VELOCITYFLAGS;
    public static final int LINEARVELOCITY;
    public static final int ANGULARVELOCITY;

    protected XrSpaceVelocityData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceVelocityData create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceVelocityData(address, container);
    }

    public XrSpaceVelocityData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceVelocityData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceVelocityFlags")
    public long velocityFlags() {
        return XrSpaceVelocityData.nvelocityFlags(this.address());
    }

    public XrVector3f linearVelocity() {
        return XrSpaceVelocityData.nlinearVelocity(this.address());
    }

    public XrVector3f angularVelocity() {
        return XrSpaceVelocityData.nangularVelocity(this.address());
    }

    public static XrSpaceVelocityData create(long address) {
        return new XrSpaceVelocityData(address, null);
    }

    @Nullable
    public static XrSpaceVelocityData createSafe(long address) {
        return address == 0L ? null : new XrSpaceVelocityData(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nvelocityFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)VELOCITYFLAGS);
    }

    public static XrVector3f nlinearVelocity(long struct) {
        return XrVector3f.create(struct + (long)LINEARVELOCITY);
    }

    public static XrVector3f nangularVelocity(long struct) {
        return XrVector3f.create(struct + (long)ANGULARVELOCITY);
    }

    static {
        Struct.Layout layout = XrSpaceVelocityData.__struct((Struct.Member[])new Struct.Member[]{XrSpaceVelocityData.__member((int)8), XrSpaceVelocityData.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF), XrSpaceVelocityData.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VELOCITYFLAGS = layout.offsetof(0);
        LINEARVELOCITY = layout.offsetof(1);
        ANGULARVELOCITY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceVelocityData, Buffer> {
        private static final XrSpaceVelocityData ELEMENT_FACTORY = XrSpaceVelocityData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceVelocityData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceVelocityFlags")
        public long velocityFlags() {
            return XrSpaceVelocityData.nvelocityFlags(this.address());
        }

        public XrVector3f linearVelocity() {
            return XrSpaceVelocityData.nlinearVelocity(this.address());
        }

        public XrVector3f angularVelocity() {
            return XrSpaceVelocityData.nangularVelocity(this.address());
        }
    }
}

