/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorCreateInfoMSFT
extends Struct<XrSpatialAnchorCreateInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int POSE;
    public static final int TIME;

    protected XrSpatialAnchorCreateInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpatialAnchorCreateInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorCreateInfoMSFT(address, container);
    }

    public XrSpatialAnchorCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpatialAnchorCreateInfoMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorCreateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpatialAnchorCreateInfoMSFT.nspace(this.address());
    }

    public XrPosef pose() {
        return XrSpatialAnchorCreateInfoMSFT.npose(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSpatialAnchorCreateInfoMSFT.ntime(this.address());
    }

    public XrSpatialAnchorCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT type$Default() {
        return this.type(1000039000);
    }

    public XrSpatialAnchorCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT space(XrSpace value) {
        XrSpatialAnchorCreateInfoMSFT.nspace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT pose(XrPosef value) {
        XrSpatialAnchorCreateInfoMSFT.npose(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT time(@NativeType(value="XrTime") long value) {
        XrSpatialAnchorCreateInfoMSFT.ntime(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT set(int type, long next, XrSpace space, XrPosef pose, long time) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.pose(pose);
        this.time(time);
        return this;
    }

    public XrSpatialAnchorCreateInfoMSFT set(XrSpatialAnchorCreateInfoMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpatialAnchorCreateInfoMSFT malloc() {
        return new XrSpatialAnchorCreateInfoMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoMSFT calloc() {
        return new XrSpatialAnchorCreateInfoMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpatialAnchorCreateInfoMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpatialAnchorCreateInfoMSFT create(long address) {
        return new XrSpatialAnchorCreateInfoMSFT(address, null);
    }

    @Nullable
    public static XrSpatialAnchorCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorCreateInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpatialAnchorCreateInfoMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorCreateInfoMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialAnchorCreateInfoMSFT malloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoMSFT calloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorCreateInfoMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSpatialAnchorCreateInfoMSFT.__member((int)4), XrSpatialAnchorCreateInfoMSFT.__member((int)POINTER_SIZE), XrSpatialAnchorCreateInfoMSFT.__member((int)POINTER_SIZE), XrSpatialAnchorCreateInfoMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrSpatialAnchorCreateInfoMSFT.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        POSE = layout.offsetof(3);
        TIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorCreateInfoMSFT ELEMENT_FACTORY = XrSpatialAnchorCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpatialAnchorCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorCreateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpatialAnchorCreateInfoMSFT.nspace(this.address());
        }

        public XrPosef pose() {
            return XrSpatialAnchorCreateInfoMSFT.npose(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSpatialAnchorCreateInfoMSFT.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000039000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpatialAnchorCreateInfoMSFT.nspace(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSpatialAnchorCreateInfoMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSpatialAnchorCreateInfoMSFT.ntime(this.address(), value);
            return this;
        }
    }
}

