/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpheref
extends Struct<XrSpheref>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int RADIUS;

    protected XrSpheref(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpheref create(long address, @Nullable ByteBuffer container) {
        return new XrSpheref(address, container);
    }

    public XrSpheref(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpheref.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef center() {
        return XrSpheref.ncenter(this.address());
    }

    public float radius() {
        return XrSpheref.nradius(this.address());
    }

    public XrSpheref center(XrPosef value) {
        XrSpheref.ncenter(this.address(), value);
        return this;
    }

    public XrSpheref center(Consumer<XrPosef> consumer) {
        consumer.accept(this.center());
        return this;
    }

    public XrSpheref radius(float value) {
        XrSpheref.nradius(this.address(), value);
        return this;
    }

    public XrSpheref set(XrPosef center, float radius) {
        this.center(center);
        this.radius(radius);
        return this;
    }

    public XrSpheref set(XrSpheref src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpheref malloc() {
        return new XrSpheref(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpheref calloc() {
        return new XrSpheref(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpheref create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpheref(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpheref create(long address) {
        return new XrSpheref(address, null);
    }

    @Nullable
    public static XrSpheref createSafe(long address) {
        return address == 0L ? null : new XrSpheref(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpheref.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpheref.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpheref malloc(MemoryStack stack) {
        return new XrSpheref(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpheref calloc(MemoryStack stack) {
        return new XrSpheref(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrPosef ncenter(long struct) {
        return XrPosef.create(struct + (long)CENTER);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static void ncenter(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CENTER), (long)XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    static {
        Struct.Layout layout = XrSpheref.__struct((Struct.Member[])new Struct.Member[]{XrSpheref.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrSpheref.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSpheref, Buffer>
    implements NativeResource {
        private static final XrSpheref ELEMENT_FACTORY = XrSpheref.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpheref getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef center() {
            return XrSpheref.ncenter(this.address());
        }

        public float radius() {
            return XrSpheref.nradius(this.address());
        }

        public Buffer center(XrPosef value) {
            XrSpheref.ncenter(this.address(), value);
            return this;
        }

        public Buffer center(Consumer<XrPosef> consumer) {
            consumer.accept(this.center());
            return this;
        }

        public Buffer radius(float value) {
            XrSpheref.nradius(this.address(), value);
            return this;
        }
    }
}

