/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpheref;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrSpherefKHR
extends XrSpheref {
    protected XrSpherefKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpherefKHR create(long address, @Nullable ByteBuffer container) {
        return new XrSpherefKHR(address, container);
    }

    public XrSpherefKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrSpherefKHR center(XrPosef value) {
        XrSpherefKHR.ncenter(this.address(), value);
        return this;
    }

    @Override
    public XrSpherefKHR center(Consumer<XrPosef> consumer) {
        consumer.accept(this.center());
        return this;
    }

    @Override
    public XrSpherefKHR radius(float value) {
        XrSpherefKHR.nradius(this.address(), value);
        return this;
    }

    @Override
    public XrSpherefKHR set(XrPosef center, float radius) {
        this.center(center);
        this.radius(radius);
        return this;
    }

    public XrSpherefKHR set(XrSpherefKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpherefKHR malloc() {
        return new XrSpherefKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpherefKHR calloc() {
        return new XrSpherefKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpherefKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpherefKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpherefKHR create(long address) {
        return new XrSpherefKHR(address, null);
    }

    @Nullable
    public static XrSpherefKHR createSafe(long address) {
        return address == 0L ? null : new XrSpherefKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpherefKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpherefKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpherefKHR malloc(MemoryStack stack) {
        return new XrSpherefKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpherefKHR calloc(MemoryStack stack) {
        return new XrSpherefKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrSpheref.Buffer {
        private static final XrSpherefKHR ELEMENT_FACTORY = XrSpherefKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSpherefKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer center(XrPosef value) {
            XrSpherefKHR.ncenter(this.address(), value);
            return this;
        }

        @Override
        public Buffer center(Consumer<XrPosef> consumer) {
            consumer.accept(this.center());
            return this;
        }

        @Override
        public Buffer radius(float value) {
            XrSpherefKHR.nradius(this.address(), value);
            return this;
        }
    }
}

