/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemAnchorPropertiesHTC
extends Struct<XrSystemAnchorPropertiesHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSANCHOR;

    protected XrSystemAnchorPropertiesHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSystemAnchorPropertiesHTC create(long address, @Nullable ByteBuffer container) {
        return new XrSystemAnchorPropertiesHTC(address, container);
    }

    public XrSystemAnchorPropertiesHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSystemAnchorPropertiesHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemAnchorPropertiesHTC.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemAnchorPropertiesHTC.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsAnchor() {
        return XrSystemAnchorPropertiesHTC.nsupportsAnchor(this.address()) != 0;
    }

    public XrSystemAnchorPropertiesHTC type(@NativeType(value="XrStructureType") int value) {
        XrSystemAnchorPropertiesHTC.ntype(this.address(), value);
        return this;
    }

    public XrSystemAnchorPropertiesHTC type$Default() {
        return this.type(1000319000);
    }

    public XrSystemAnchorPropertiesHTC next(@NativeType(value="void *") long value) {
        XrSystemAnchorPropertiesHTC.nnext(this.address(), value);
        return this;
    }

    public XrSystemAnchorPropertiesHTC set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemAnchorPropertiesHTC set(XrSystemAnchorPropertiesHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSystemAnchorPropertiesHTC malloc() {
        return new XrSystemAnchorPropertiesHTC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSystemAnchorPropertiesHTC calloc() {
        return new XrSystemAnchorPropertiesHTC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSystemAnchorPropertiesHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSystemAnchorPropertiesHTC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSystemAnchorPropertiesHTC create(long address) {
        return new XrSystemAnchorPropertiesHTC(address, null);
    }

    @Nullable
    public static XrSystemAnchorPropertiesHTC createSafe(long address) {
        return address == 0L ? null : new XrSystemAnchorPropertiesHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSystemAnchorPropertiesHTC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemAnchorPropertiesHTC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemAnchorPropertiesHTC malloc(MemoryStack stack) {
        return new XrSystemAnchorPropertiesHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemAnchorPropertiesHTC calloc(MemoryStack stack) {
        return new XrSystemAnchorPropertiesHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nsupportsAnchor(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSANCHOR);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSystemAnchorPropertiesHTC.__struct((Struct.Member[])new Struct.Member[]{XrSystemAnchorPropertiesHTC.__member((int)4), XrSystemAnchorPropertiesHTC.__member((int)POINTER_SIZE), XrSystemAnchorPropertiesHTC.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSANCHOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemAnchorPropertiesHTC, Buffer>
    implements NativeResource {
        private static final XrSystemAnchorPropertiesHTC ELEMENT_FACTORY = XrSystemAnchorPropertiesHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSystemAnchorPropertiesHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemAnchorPropertiesHTC.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemAnchorPropertiesHTC.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsAnchor() {
            return XrSystemAnchorPropertiesHTC.nsupportsAnchor(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemAnchorPropertiesHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000319000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemAnchorPropertiesHTC.nnext(this.address(), value);
            return this;
        }
    }
}

