/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemGraphicsProperties
extends Struct<XrSystemGraphicsProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXSWAPCHAINIMAGEHEIGHT;
    public static final int MAXSWAPCHAINIMAGEWIDTH;
    public static final int MAXLAYERCOUNT;

    protected XrSystemGraphicsProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSystemGraphicsProperties create(long address, @Nullable ByteBuffer container) {
        return new XrSystemGraphicsProperties(address, container);
    }

    public XrSystemGraphicsProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSystemGraphicsProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int maxSwapchainImageHeight() {
        return XrSystemGraphicsProperties.nmaxSwapchainImageHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSwapchainImageWidth() {
        return XrSystemGraphicsProperties.nmaxSwapchainImageWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxLayerCount() {
        return XrSystemGraphicsProperties.nmaxLayerCount(this.address());
    }

    public XrSystemGraphicsProperties maxSwapchainImageHeight(@NativeType(value="uint32_t") int value) {
        XrSystemGraphicsProperties.nmaxSwapchainImageHeight(this.address(), value);
        return this;
    }

    public XrSystemGraphicsProperties maxSwapchainImageWidth(@NativeType(value="uint32_t") int value) {
        XrSystemGraphicsProperties.nmaxSwapchainImageWidth(this.address(), value);
        return this;
    }

    public XrSystemGraphicsProperties maxLayerCount(@NativeType(value="uint32_t") int value) {
        XrSystemGraphicsProperties.nmaxLayerCount(this.address(), value);
        return this;
    }

    public XrSystemGraphicsProperties set(int maxSwapchainImageHeight, int maxSwapchainImageWidth, int maxLayerCount) {
        this.maxSwapchainImageHeight(maxSwapchainImageHeight);
        this.maxSwapchainImageWidth(maxSwapchainImageWidth);
        this.maxLayerCount(maxLayerCount);
        return this;
    }

    public XrSystemGraphicsProperties set(XrSystemGraphicsProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSystemGraphicsProperties malloc() {
        return new XrSystemGraphicsProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSystemGraphicsProperties calloc() {
        return new XrSystemGraphicsProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSystemGraphicsProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSystemGraphicsProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSystemGraphicsProperties create(long address) {
        return new XrSystemGraphicsProperties(address, null);
    }

    @Nullable
    public static XrSystemGraphicsProperties createSafe(long address) {
        return address == 0L ? null : new XrSystemGraphicsProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSystemGraphicsProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemGraphicsProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemGraphicsProperties malloc(MemoryStack stack) {
        return new XrSystemGraphicsProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemGraphicsProperties calloc(MemoryStack stack) {
        return new XrSystemGraphicsProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmaxSwapchainImageHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXSWAPCHAINIMAGEHEIGHT);
    }

    public static int nmaxSwapchainImageWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXSWAPCHAINIMAGEWIDTH);
    }

    public static int nmaxLayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXLAYERCOUNT);
    }

    public static void nmaxSwapchainImageHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXSWAPCHAINIMAGEHEIGHT, value);
    }

    public static void nmaxSwapchainImageWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXSWAPCHAINIMAGEWIDTH, value);
    }

    public static void nmaxLayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXLAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = XrSystemGraphicsProperties.__struct((Struct.Member[])new Struct.Member[]{XrSystemGraphicsProperties.__member((int)4), XrSystemGraphicsProperties.__member((int)4), XrSystemGraphicsProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXSWAPCHAINIMAGEHEIGHT = layout.offsetof(0);
        MAXSWAPCHAINIMAGEWIDTH = layout.offsetof(1);
        MAXLAYERCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemGraphicsProperties, Buffer>
    implements NativeResource {
        private static final XrSystemGraphicsProperties ELEMENT_FACTORY = XrSystemGraphicsProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSystemGraphicsProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int maxSwapchainImageHeight() {
            return XrSystemGraphicsProperties.nmaxSwapchainImageHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSwapchainImageWidth() {
            return XrSystemGraphicsProperties.nmaxSwapchainImageWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxLayerCount() {
            return XrSystemGraphicsProperties.nmaxLayerCount(this.address());
        }

        public Buffer maxSwapchainImageHeight(@NativeType(value="uint32_t") int value) {
            XrSystemGraphicsProperties.nmaxSwapchainImageHeight(this.address(), value);
            return this;
        }

        public Buffer maxSwapchainImageWidth(@NativeType(value="uint32_t") int value) {
            XrSystemGraphicsProperties.nmaxSwapchainImageWidth(this.address(), value);
            return this;
        }

        public Buffer maxLayerCount(@NativeType(value="uint32_t") int value) {
            XrSystemGraphicsProperties.nmaxLayerCount(this.address(), value);
            return this;
        }
    }
}

