/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class XrVulkanDeviceCreateInfoKHR
extends Struct<XrVulkanDeviceCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SYSTEMID;
    public static final int CREATEFLAGS;
    public static final int PFNGETINSTANCEPROCADDR;
    public static final int VULKANPHYSICALDEVICE;
    public static final int VULKANCREATEINFO;
    public static final int VULKANALLOCATOR;

    protected XrVulkanDeviceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrVulkanDeviceCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new XrVulkanDeviceCreateInfoKHR(address, container);
    }

    public XrVulkanDeviceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrVulkanDeviceCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVulkanDeviceCreateInfoKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVulkanDeviceCreateInfoKHR.nnext(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrVulkanDeviceCreateInfoKHR.nsystemId(this.address());
    }

    @NativeType(value="XrVulkanDeviceCreateFlagsKHR")
    public long createFlags() {
        return XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address());
    }

    @NativeType(value="PFN_vkGetInstanceProcAddr")
    public long pfnGetInstanceProcAddr() {
        return XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long vulkanPhysicalDevice() {
        return XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address());
    }

    @NativeType(value="VkDeviceCreateInfo const *")
    public VkDeviceCreateInfo vulkanCreateInfo() {
        return XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks vulkanAllocator() {
        return XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address());
    }

    public XrVulkanDeviceCreateInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrVulkanDeviceCreateInfoKHR.ntype(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR type$Default() {
        return this.type(1000090001);
    }

    public XrVulkanDeviceCreateInfoKHR next(@NativeType(value="void const *") long value) {
        XrVulkanDeviceCreateInfoKHR.nnext(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR systemId(@NativeType(value="XrSystemId") long value) {
        XrVulkanDeviceCreateInfoKHR.nsystemId(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR createFlags(@NativeType(value="XrVulkanDeviceCreateFlagsKHR") long value) {
        XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
        XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR vulkanPhysicalDevice(VkPhysicalDevice value) {
        XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR vulkanCreateInfo(@NativeType(value="VkDeviceCreateInfo const *") VkDeviceCreateInfo value) {
        XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR vulkanAllocator(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR set(int type, long next, long systemId, long createFlags, long pfnGetInstanceProcAddr, VkPhysicalDevice vulkanPhysicalDevice, VkDeviceCreateInfo vulkanCreateInfo, @Nullable VkAllocationCallbacks vulkanAllocator) {
        this.type(type);
        this.next(next);
        this.systemId(systemId);
        this.createFlags(createFlags);
        this.pfnGetInstanceProcAddr(pfnGetInstanceProcAddr);
        this.vulkanPhysicalDevice(vulkanPhysicalDevice);
        this.vulkanCreateInfo(vulkanCreateInfo);
        this.vulkanAllocator(vulkanAllocator);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR set(XrVulkanDeviceCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrVulkanDeviceCreateInfoKHR malloc() {
        return new XrVulkanDeviceCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrVulkanDeviceCreateInfoKHR calloc() {
        return new XrVulkanDeviceCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrVulkanDeviceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrVulkanDeviceCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrVulkanDeviceCreateInfoKHR create(long address) {
        return new XrVulkanDeviceCreateInfoKHR(address, null);
    }

    @Nullable
    public static XrVulkanDeviceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new XrVulkanDeviceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrVulkanDeviceCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVulkanDeviceCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVulkanDeviceCreateInfoKHR malloc(MemoryStack stack) {
        return new XrVulkanDeviceCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVulkanDeviceCreateInfoKHR calloc(MemoryStack stack) {
        return new XrVulkanDeviceCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nsystemId(long struct) {
        return UNSAFE.getLong(null, struct + (long)SYSTEMID);
    }

    public static long ncreateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)CREATEFLAGS);
    }

    public static long npfnGetInstanceProcAddr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PFNGETINSTANCEPROCADDR));
    }

    public static long nvulkanPhysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)VULKANPHYSICALDEVICE));
    }

    public static VkDeviceCreateInfo nvulkanCreateInfo(long struct) {
        return VkDeviceCreateInfo.create((long)MemoryUtil.memGetAddress((long)(struct + (long)VULKANCREATEINFO)));
    }

    @Nullable
    public static VkAllocationCallbacks nvulkanAllocator(long struct) {
        return VkAllocationCallbacks.createSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)VULKANALLOCATOR)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsystemId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SYSTEMID, value);
    }

    public static void ncreateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CREATEFLAGS, value);
    }

    public static void npfnGetInstanceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNGETINSTANCEPROCADDR), (long)Checks.check((long)value));
    }

    public static void nvulkanPhysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VULKANPHYSICALDEVICE), (long)value.address());
    }

    public static void nvulkanCreateInfo(long struct, VkDeviceCreateInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VULKANCREATEINFO), (long)value.address());
    }

    public static void nvulkanAllocator(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VULKANALLOCATOR), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PFNGETINSTANCEPROCADDR)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VULKANPHYSICALDEVICE)));
        long vulkanCreateInfo = MemoryUtil.memGetAddress((long)(struct + (long)VULKANCREATEINFO));
        Checks.check((long)vulkanCreateInfo);
        VkDeviceCreateInfo.validate((long)vulkanCreateInfo);
    }

    static {
        Struct.Layout layout = XrVulkanDeviceCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{XrVulkanDeviceCreateInfoKHR.__member((int)4), XrVulkanDeviceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member((int)8), XrVulkanDeviceCreateInfoKHR.__member((int)8), XrVulkanDeviceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SYSTEMID = layout.offsetof(2);
        CREATEFLAGS = layout.offsetof(3);
        PFNGETINSTANCEPROCADDR = layout.offsetof(4);
        VULKANPHYSICALDEVICE = layout.offsetof(5);
        VULKANCREATEINFO = layout.offsetof(6);
        VULKANALLOCATOR = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrVulkanDeviceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final XrVulkanDeviceCreateInfoKHR ELEMENT_FACTORY = XrVulkanDeviceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrVulkanDeviceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVulkanDeviceCreateInfoKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVulkanDeviceCreateInfoKHR.nnext(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrVulkanDeviceCreateInfoKHR.nsystemId(this.address());
        }

        @NativeType(value="XrVulkanDeviceCreateFlagsKHR")
        public long createFlags() {
            return XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address());
        }

        @NativeType(value="PFN_vkGetInstanceProcAddr")
        public long pfnGetInstanceProcAddr() {
            return XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long vulkanPhysicalDevice() {
            return XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address());
        }

        @NativeType(value="VkDeviceCreateInfo const *")
        public VkDeviceCreateInfo vulkanCreateInfo() {
            return XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkAllocationCallbacks const *")
        public VkAllocationCallbacks vulkanAllocator() {
            return XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVulkanDeviceCreateInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000090001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVulkanDeviceCreateInfoKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer systemId(@NativeType(value="XrSystemId") long value) {
            XrVulkanDeviceCreateInfoKHR.nsystemId(this.address(), value);
            return this;
        }

        public Buffer createFlags(@NativeType(value="XrVulkanDeviceCreateFlagsKHR") long value) {
            XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
            XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
            return this;
        }

        public Buffer vulkanPhysicalDevice(VkPhysicalDevice value) {
            XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address(), value);
            return this;
        }

        public Buffer vulkanCreateInfo(@NativeType(value="VkDeviceCreateInfo const *") VkDeviceCreateInfo value) {
            XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
            return this;
        }

        public Buffer vulkanAllocator(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
            XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address(), value);
            return this;
        }
    }
}

