/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.hwloc.hwloc_info_s;

@NativeType(value="struct hwloc_infos_s")
public class hwloc_infos_s
extends Struct<hwloc_infos_s>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ARRAY;
    public static final int COUNT;
    public static final int ALLOCATED;

    protected hwloc_infos_s(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected hwloc_infos_s create(long address, @Nullable ByteBuffer container) {
        return new hwloc_infos_s(address, container);
    }

    public hwloc_infos_s(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), hwloc_infos_s.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="struct hwloc_info_s *")
    public hwloc_info_s.Buffer array() {
        return hwloc_infos_s.narray(this.address());
    }

    @NativeType(value="unsigned")
    public int count() {
        return hwloc_infos_s.ncount(this.address());
    }

    public static hwloc_infos_s malloc() {
        return new hwloc_infos_s(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static hwloc_infos_s calloc() {
        return new hwloc_infos_s(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static hwloc_infos_s create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new hwloc_infos_s(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static hwloc_infos_s create(long address) {
        return new hwloc_infos_s(address, null);
    }

    @Nullable
    public static hwloc_infos_s createSafe(long address) {
        return address == 0L ? null : new hwloc_infos_s(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)hwloc_infos_s.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hwloc_infos_s.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hwloc_infos_s malloc(MemoryStack stack) {
        return new hwloc_infos_s(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hwloc_infos_s calloc(MemoryStack stack) {
        return new hwloc_infos_s(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static hwloc_info_s.Buffer narray(long struct) {
        return hwloc_info_s.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ARRAY)), hwloc_infos_s.ncount(struct));
    }

    public static int ncount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNT);
    }

    public static int nallocated(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCATED);
    }

    static {
        Struct.Layout layout = hwloc_infos_s.__struct((Struct.Member[])new Struct.Member[]{hwloc_infos_s.__member((int)POINTER_SIZE), hwloc_infos_s.__member((int)4), hwloc_infos_s.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ARRAY = layout.offsetof(0);
        COUNT = layout.offsetof(1);
        ALLOCATED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<hwloc_infos_s, Buffer>
    implements NativeResource {
        private static final hwloc_infos_s ELEMENT_FACTORY = hwloc_infos_s.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected hwloc_infos_s getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="struct hwloc_info_s *")
        public hwloc_info_s.Buffer array() {
            return hwloc_infos_s.narray(this.address());
        }

        @NativeType(value="unsigned")
        public int count() {
            return hwloc_infos_s.ncount(this.address());
        }
    }
}

