/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.CXIdxDeclInfo;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxCXXClassDeclInfo
extends Struct<CXIdxCXXClassDeclInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DECLINFO;
    public static final int BASES;
    public static final int NUMBASES;

    protected CXIdxCXXClassDeclInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXIdxCXXClassDeclInfo create(long address, @Nullable ByteBuffer container) {
        return new CXIdxCXXClassDeclInfo(address, container);
    }

    public CXIdxCXXClassDeclInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxCXXClassDeclInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxDeclInfo const *")
    public CXIdxDeclInfo declInfo() {
        return CXIdxCXXClassDeclInfo.ndeclInfo(this.address());
    }

    @NativeType(value="CXIdxBaseClassInfo const * const *")
    public PointerBuffer bases() {
        return CXIdxCXXClassDeclInfo.nbases(this.address());
    }

    @NativeType(value="unsigned")
    public int numBases() {
        return CXIdxCXXClassDeclInfo.nnumBases(this.address());
    }

    public static CXIdxCXXClassDeclInfo create(long address) {
        return new CXIdxCXXClassDeclInfo(address, null);
    }

    @Nullable
    public static CXIdxCXXClassDeclInfo createSafe(long address) {
        return address == 0L ? null : new CXIdxCXXClassDeclInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CXIdxDeclInfo ndeclInfo(long struct) {
        return CXIdxDeclInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)DECLINFO)));
    }

    public static PointerBuffer nbases(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BASES)), (int)CXIdxCXXClassDeclInfo.nnumBases(struct));
    }

    public static int nnumBases(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMBASES);
    }

    static {
        Struct.Layout layout = CXIdxCXXClassDeclInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxCXXClassDeclInfo.__member((int)POINTER_SIZE), CXIdxCXXClassDeclInfo.__member((int)POINTER_SIZE), CXIdxCXXClassDeclInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DECLINFO = layout.offsetof(0);
        BASES = layout.offsetof(1);
        NUMBASES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXIdxCXXClassDeclInfo, Buffer> {
        private static final CXIdxCXXClassDeclInfo ELEMENT_FACTORY = CXIdxCXXClassDeclInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxCXXClassDeclInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxDeclInfo const *")
        public CXIdxDeclInfo declInfo() {
            return CXIdxCXXClassDeclInfo.ndeclInfo(this.address());
        }

        @NativeType(value="CXIdxBaseClassInfo const * const *")
        public PointerBuffer bases() {
            return CXIdxCXXClassDeclInfo.nbases(this.address());
        }

        @NativeType(value="unsigned")
        public int numBases() {
            return CXIdxCXXClassDeclInfo.nnumBases(this.address());
        }
    }
}

