/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXString;
import org.lwjgl.llvm.CXVersion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXPlatformAvailability
extends Struct<CXPlatformAvailability>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLATFORM;
    public static final int INTRODUCED;
    public static final int DEPRECATED;
    public static final int OBSOLETED;
    public static final int UNAVAILABLE;
    public static final int MESSAGE;

    protected CXPlatformAvailability(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXPlatformAvailability create(long address, @Nullable ByteBuffer container) {
        return new CXPlatformAvailability(address, container);
    }

    public CXPlatformAvailability(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXPlatformAvailability.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CXString Platform() {
        return CXPlatformAvailability.nPlatform(this.address());
    }

    public CXVersion Introduced() {
        return CXPlatformAvailability.nIntroduced(this.address());
    }

    public CXVersion Deprecated() {
        return CXPlatformAvailability.nDeprecated(this.address());
    }

    public CXVersion Obsoleted() {
        return CXPlatformAvailability.nObsoleted(this.address());
    }

    public int Unavailable() {
        return CXPlatformAvailability.nUnavailable(this.address());
    }

    public CXString Message() {
        return CXPlatformAvailability.nMessage(this.address());
    }

    public static CXPlatformAvailability malloc() {
        return new CXPlatformAvailability(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXPlatformAvailability calloc() {
        return new CXPlatformAvailability(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXPlatformAvailability create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXPlatformAvailability(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXPlatformAvailability create(long address) {
        return new CXPlatformAvailability(address, null);
    }

    @Nullable
    public static CXPlatformAvailability createSafe(long address) {
        return address == 0L ? null : new CXPlatformAvailability(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXPlatformAvailability.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXPlatformAvailability.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXPlatformAvailability mallocStack() {
        return CXPlatformAvailability.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXPlatformAvailability callocStack() {
        return CXPlatformAvailability.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXPlatformAvailability mallocStack(MemoryStack stack) {
        return CXPlatformAvailability.malloc(stack);
    }

    @Deprecated
    public static CXPlatformAvailability callocStack(MemoryStack stack) {
        return CXPlatformAvailability.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXPlatformAvailability.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXPlatformAvailability.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXPlatformAvailability.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXPlatformAvailability.calloc(capacity, stack);
    }

    public static CXPlatformAvailability malloc(MemoryStack stack) {
        return new CXPlatformAvailability(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXPlatformAvailability calloc(MemoryStack stack) {
        return new CXPlatformAvailability(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CXString nPlatform(long struct) {
        return CXString.create(struct + (long)PLATFORM);
    }

    public static CXVersion nIntroduced(long struct) {
        return CXVersion.create(struct + (long)INTRODUCED);
    }

    public static CXVersion nDeprecated(long struct) {
        return CXVersion.create(struct + (long)DEPRECATED);
    }

    public static CXVersion nObsoleted(long struct) {
        return CXVersion.create(struct + (long)OBSOLETED);
    }

    public static int nUnavailable(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNAVAILABLE);
    }

    public static CXString nMessage(long struct) {
        return CXString.create(struct + (long)MESSAGE);
    }

    static {
        Struct.Layout layout = CXPlatformAvailability.__struct((Struct.Member[])new Struct.Member[]{CXPlatformAvailability.__member((int)CXString.SIZEOF, (int)CXString.ALIGNOF), CXPlatformAvailability.__member((int)CXVersion.SIZEOF, (int)CXVersion.ALIGNOF), CXPlatformAvailability.__member((int)CXVersion.SIZEOF, (int)CXVersion.ALIGNOF), CXPlatformAvailability.__member((int)CXVersion.SIZEOF, (int)CXVersion.ALIGNOF), CXPlatformAvailability.__member((int)4), CXPlatformAvailability.__member((int)CXString.SIZEOF, (int)CXString.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLATFORM = layout.offsetof(0);
        INTRODUCED = layout.offsetof(1);
        DEPRECATED = layout.offsetof(2);
        OBSOLETED = layout.offsetof(3);
        UNAVAILABLE = layout.offsetof(4);
        MESSAGE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CXPlatformAvailability, Buffer>
    implements NativeResource {
        private static final CXPlatformAvailability ELEMENT_FACTORY = CXPlatformAvailability.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXPlatformAvailability getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CXString Platform() {
            return CXPlatformAvailability.nPlatform(this.address());
        }

        public CXVersion Introduced() {
            return CXPlatformAvailability.nIntroduced(this.address());
        }

        public CXVersion Deprecated() {
            return CXPlatformAvailability.nDeprecated(this.address());
        }

        public CXVersion Obsoleted() {
            return CXPlatformAvailability.nObsoleted(this.address());
        }

        public int Unavailable() {
            return CXPlatformAvailability.nUnavailable(this.address());
        }

        public CXString Message() {
            return CXPlatformAvailability.nMessage(this.address());
        }
    }
}

