/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LLVMOpInfoSymbol1")
public class LLVMOpInfoSymbol1
extends Struct<LLVMOpInfoSymbol1>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PRESENT;
    public static final int NAME;
    public static final int VALUE;

    protected LLVMOpInfoSymbol1(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LLVMOpInfoSymbol1 create(long address, @Nullable ByteBuffer container) {
        return new LLVMOpInfoSymbol1(address, container);
    }

    public LLVMOpInfoSymbol1(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOpInfoSymbol1.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long Present() {
        return LLVMOpInfoSymbol1.nPresent(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer Name() {
        return LLVMOpInfoSymbol1.nName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String NameString() {
        return LLVMOpInfoSymbol1.nNameString(this.address());
    }

    @NativeType(value="uint64_t")
    public long Value() {
        return LLVMOpInfoSymbol1.nValue(this.address());
    }

    public LLVMOpInfoSymbol1 Present(@NativeType(value="uint64_t") long value) {
        LLVMOpInfoSymbol1.nPresent(this.address(), value);
        return this;
    }

    public LLVMOpInfoSymbol1 Name(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        LLVMOpInfoSymbol1.nName(this.address(), value);
        return this;
    }

    public LLVMOpInfoSymbol1 Value(@NativeType(value="uint64_t") long value) {
        LLVMOpInfoSymbol1.nValue(this.address(), value);
        return this;
    }

    public LLVMOpInfoSymbol1 set(long Present, @Nullable ByteBuffer Name, long Value) {
        this.Present(Present);
        this.Name(Name);
        this.Value(Value);
        return this;
    }

    public LLVMOpInfoSymbol1 set(LLVMOpInfoSymbol1 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOpInfoSymbol1 malloc() {
        return new LLVMOpInfoSymbol1(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LLVMOpInfoSymbol1 calloc() {
        return new LLVMOpInfoSymbol1(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LLVMOpInfoSymbol1 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LLVMOpInfoSymbol1(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LLVMOpInfoSymbol1 create(long address) {
        return new LLVMOpInfoSymbol1(address, null);
    }

    @Nullable
    public static LLVMOpInfoSymbol1 createSafe(long address) {
        return address == 0L ? null : new LLVMOpInfoSymbol1(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LLVMOpInfoSymbol1.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOpInfoSymbol1.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 mallocStack() {
        return LLVMOpInfoSymbol1.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 callocStack() {
        return LLVMOpInfoSymbol1.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 mallocStack(MemoryStack stack) {
        return LLVMOpInfoSymbol1.malloc(stack);
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 callocStack(MemoryStack stack) {
        return LLVMOpInfoSymbol1.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LLVMOpInfoSymbol1.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LLVMOpInfoSymbol1.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfoSymbol1.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfoSymbol1.calloc(capacity, stack);
    }

    public static LLVMOpInfoSymbol1 malloc(MemoryStack stack) {
        return new LLVMOpInfoSymbol1(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOpInfoSymbol1 calloc(MemoryStack stack) {
        return new LLVMOpInfoSymbol1(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nPresent(long struct) {
        return UNSAFE.getLong(null, struct + (long)PRESENT);
    }

    @Nullable
    public static ByteBuffer nName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    @Nullable
    public static String nNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static long nValue(long struct) {
        return UNSAFE.getLong(null, struct + (long)VALUE);
    }

    public static void nPresent(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PRESENT, value);
    }

    public static void nName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nValue(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VALUE, value);
    }

    static {
        Struct.Layout layout = LLVMOpInfoSymbol1.__struct((Struct.Member[])new Struct.Member[]{LLVMOpInfoSymbol1.__member((int)8), LLVMOpInfoSymbol1.__member((int)POINTER_SIZE), LLVMOpInfoSymbol1.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PRESENT = layout.offsetof(0);
        NAME = layout.offsetof(1);
        VALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<LLVMOpInfoSymbol1, Buffer>
    implements NativeResource {
        private static final LLVMOpInfoSymbol1 ELEMENT_FACTORY = LLVMOpInfoSymbol1.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOpInfoSymbol1 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long Present() {
            return LLVMOpInfoSymbol1.nPresent(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer Name() {
            return LLVMOpInfoSymbol1.nName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String NameString() {
            return LLVMOpInfoSymbol1.nNameString(this.address());
        }

        @NativeType(value="uint64_t")
        public long Value() {
            return LLVMOpInfoSymbol1.nValue(this.address());
        }

        public Buffer Present(@NativeType(value="uint64_t") long value) {
            LLVMOpInfoSymbol1.nPresent(this.address(), value);
            return this;
        }

        public Buffer Name(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            LLVMOpInfoSymbol1.nName(this.address(), value);
            return this;
        }

        public Buffer Value(@NativeType(value="uint64_t") long value) {
            LLVMOpInfoSymbol1.nValue(this.address(), value);
            return this;
        }
    }
}

