/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LTOObjectBuffer
extends Struct<LTOObjectBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int SIZE;

    protected LTOObjectBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LTOObjectBuffer create(long address, @Nullable ByteBuffer container) {
        return new LTOObjectBuffer(address, container);
    }

    public LTOObjectBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LTOObjectBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer Buffer() {
        return LTOObjectBuffer.nBuffer(this.address());
    }

    @NativeType(value="size_t")
    public long Size() {
        return LTOObjectBuffer.nSize(this.address());
    }

    public static LTOObjectBuffer malloc() {
        return new LTOObjectBuffer(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LTOObjectBuffer calloc() {
        return new LTOObjectBuffer(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LTOObjectBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LTOObjectBuffer(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LTOObjectBuffer create(long address) {
        return new LTOObjectBuffer(address, null);
    }

    @Nullable
    public static LTOObjectBuffer createSafe(long address) {
        return address == 0L ? null : new LTOObjectBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LTOObjectBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LTOObjectBuffer.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LTOObjectBuffer mallocStack() {
        return LTOObjectBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LTOObjectBuffer callocStack() {
        return LTOObjectBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LTOObjectBuffer mallocStack(MemoryStack stack) {
        return LTOObjectBuffer.malloc(stack);
    }

    @Deprecated
    public static LTOObjectBuffer callocStack(MemoryStack stack) {
        return LTOObjectBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LTOObjectBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LTOObjectBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.calloc(capacity, stack);
    }

    public static LTOObjectBuffer malloc(MemoryStack stack) {
        return new LTOObjectBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LTOObjectBuffer calloc(MemoryStack stack) {
        return new LTOObjectBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nBuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)((int)LTOObjectBuffer.nSize(struct)));
    }

    public static long nSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    static {
        Struct.Layout layout = LTOObjectBuffer.__struct((Struct.Member[])new Struct.Member[]{LTOObjectBuffer.__member((int)POINTER_SIZE), LTOObjectBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LTOObjectBuffer, Buffer>
    implements NativeResource {
        private static final LTOObjectBuffer ELEMENT_FACTORY = LTOObjectBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LTOObjectBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer Buffer() {
            return LTOObjectBuffer.nBuffer(this.address());
        }

        @NativeType(value="size_t")
        public long Size() {
            return LTOObjectBuffer.nSize(this.address());
        }
    }
}

