/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_encoder_stats_t")
public class BGFXEncoderStats
extends Struct<BGFXEncoderStats> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPUTIMEBEGIN;
    public static final int CPUTIMEEND;

    protected BGFXEncoderStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXEncoderStats create(long address, @Nullable ByteBuffer container) {
        return new BGFXEncoderStats(address, container);
    }

    public BGFXEncoderStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXEncoderStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int64_t")
    public long cpuTimeBegin() {
        return BGFXEncoderStats.ncpuTimeBegin(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeEnd() {
        return BGFXEncoderStats.ncpuTimeEnd(this.address());
    }

    public static BGFXEncoderStats create(long address) {
        return new BGFXEncoderStats(address, null);
    }

    @Nullable
    public static BGFXEncoderStats createSafe(long address) {
        return address == 0L ? null : new BGFXEncoderStats(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long ncpuTimeBegin(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEBEGIN);
    }

    public static long ncpuTimeEnd(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEEND);
    }

    static {
        Struct.Layout layout = BGFXEncoderStats.__struct((Struct.Member[])new Struct.Member[]{BGFXEncoderStats.__member((int)8), BGFXEncoderStats.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPUTIMEBEGIN = layout.offsetof(0);
        CPUTIMEEND = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXEncoderStats, Buffer> {
        private static final BGFXEncoderStats ELEMENT_FACTORY = BGFXEncoderStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXEncoderStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int64_t")
        public long cpuTimeBegin() {
            return BGFXEncoderStats.ncpuTimeBegin(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeEnd() {
            return BGFXEncoderStats.ncpuTimeEnd(this.address());
        }
    }
}

