/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_instance_data_buffer_t")
public class BGFXInstanceDataBuffer
extends Struct<BGFXInstanceDataBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int OFFSET;
    public static final int NUM;
    public static final int STRIDE;
    public static final int HANDLE;

    protected BGFXInstanceDataBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXInstanceDataBuffer create(long address, @Nullable ByteBuffer container) {
        return new BGFXInstanceDataBuffer(address, container);
    }

    public BGFXInstanceDataBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXInstanceDataBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXInstanceDataBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXInstanceDataBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return BGFXInstanceDataBuffer.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int num() {
        return BGFXInstanceDataBuffer.nnum(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXInstanceDataBuffer.nstride(this.address());
    }

    @NativeType(value="bgfx_vertex_buffer_handle_t")
    public short handle() {
        return BGFXInstanceDataBuffer.nhandle(this.address());
    }

    public BGFXInstanceDataBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXInstanceDataBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer offset(@NativeType(value="uint32_t") int value) {
        BGFXInstanceDataBuffer.noffset(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer num(@NativeType(value="uint32_t") int value) {
        BGFXInstanceDataBuffer.nnum(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer stride(@NativeType(value="uint16_t") short value) {
        BGFXInstanceDataBuffer.nstride(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
        BGFXInstanceDataBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer set(ByteBuffer data, int offset, int num, short stride, short handle) {
        this.data(data);
        this.offset(offset);
        this.num(num);
        this.stride(stride);
        this.handle(handle);
        return this;
    }

    public BGFXInstanceDataBuffer set(BGFXInstanceDataBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXInstanceDataBuffer malloc() {
        return new BGFXInstanceDataBuffer(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXInstanceDataBuffer calloc() {
        return new BGFXInstanceDataBuffer(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXInstanceDataBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXInstanceDataBuffer(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXInstanceDataBuffer create(long address) {
        return new BGFXInstanceDataBuffer(address, null);
    }

    @Nullable
    public static BGFXInstanceDataBuffer createSafe(long address) {
        return address == 0L ? null : new BGFXInstanceDataBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)BGFXInstanceDataBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXInstanceDataBuffer.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXInstanceDataBuffer mallocStack() {
        return BGFXInstanceDataBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInstanceDataBuffer callocStack() {
        return BGFXInstanceDataBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInstanceDataBuffer mallocStack(MemoryStack stack) {
        return BGFXInstanceDataBuffer.malloc(stack);
    }

    @Deprecated
    public static BGFXInstanceDataBuffer callocStack(MemoryStack stack) {
        return BGFXInstanceDataBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXInstanceDataBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXInstanceDataBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.calloc(capacity, stack);
    }

    public static BGFXInstanceDataBuffer malloc(MemoryStack stack) {
        return new BGFXInstanceDataBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXInstanceDataBuffer calloc(MemoryStack stack) {
        return new BGFXInstanceDataBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)BGFXInstanceDataBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nnum(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM);
    }

    public static short nstride(long struct) {
        return UNSAFE.getShort(null, struct + (long)STRIDE);
    }

    public static short nhandle(long struct) {
        return UNSAFE.getShort(null, struct + (long)HANDLE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        BGFXInstanceDataBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    public static void nnum(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM, value);
    }

    public static void nstride(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)STRIDE, value);
    }

    public static void nhandle(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)HANDLE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = BGFXInstanceDataBuffer.__struct((Struct.Member[])new Struct.Member[]{BGFXInstanceDataBuffer.__member((int)POINTER_SIZE), BGFXInstanceDataBuffer.__member((int)4), BGFXInstanceDataBuffer.__member((int)4), BGFXInstanceDataBuffer.__member((int)4), BGFXInstanceDataBuffer.__member((int)2), BGFXInstanceDataBuffer.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        NUM = layout.offsetof(3);
        STRIDE = layout.offsetof(4);
        HANDLE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXInstanceDataBuffer, Buffer>
    implements NativeResource {
        private static final BGFXInstanceDataBuffer ELEMENT_FACTORY = BGFXInstanceDataBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXInstanceDataBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXInstanceDataBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXInstanceDataBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return BGFXInstanceDataBuffer.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int num() {
            return BGFXInstanceDataBuffer.nnum(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXInstanceDataBuffer.nstride(this.address());
        }

        @NativeType(value="bgfx_vertex_buffer_handle_t")
        public short handle() {
            return BGFXInstanceDataBuffer.nhandle(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXInstanceDataBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            BGFXInstanceDataBuffer.noffset(this.address(), value);
            return this;
        }

        public Buffer num(@NativeType(value="uint32_t") int value) {
            BGFXInstanceDataBuffer.nnum(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXInstanceDataBuffer.nstride(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
            BGFXInstanceDataBuffer.nhandle(this.address(), value);
            return this;
        }
    }
}

