/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.bgfx.BGFXCaps;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_internal_data_t")
public class BGFXInternalData
extends Struct<BGFXInternalData> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CAPS;
    public static final int CONTEXT;

    protected BGFXInternalData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXInternalData create(long address, @Nullable ByteBuffer container) {
        return new BGFXInternalData(address, container);
    }

    public BGFXInternalData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXInternalData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_caps_t *")
    public BGFXCaps caps() {
        return BGFXInternalData.ncaps(this.address());
    }

    @NativeType(value="void *")
    public long context() {
        return BGFXInternalData.ncontext(this.address());
    }

    public static BGFXInternalData create(long address) {
        return new BGFXInternalData(address, null);
    }

    @Nullable
    public static BGFXInternalData createSafe(long address) {
        return address == 0L ? null : new BGFXInternalData(address, null);
    }

    public static BGFXCaps ncaps(long struct) {
        return BGFXCaps.create(MemoryUtil.memGetAddress((long)(struct + (long)CAPS)));
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    static {
        Struct.Layout layout = BGFXInternalData.__struct((Struct.Member[])new Struct.Member[]{BGFXInternalData.__member((int)POINTER_SIZE), BGFXInternalData.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CAPS = layout.offsetof(0);
        CONTEXT = layout.offsetof(1);
    }
}

