/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transform_t")
public class BGFXTransform
extends Struct<BGFXTransform>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUM;

    protected BGFXTransform(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXTransform create(long address, @Nullable ByteBuffer container) {
        return new BGFXTransform(address, container);
    }

    public BGFXTransform(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXTransform.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer data() {
        return BGFXTransform.ndata(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXTransform.nnum(this.address());
    }

    public static BGFXTransform malloc() {
        return new BGFXTransform(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXTransform calloc() {
        return new BGFXTransform(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXTransform create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXTransform(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXTransform create(long address) {
        return new BGFXTransform(address, null);
    }

    @Nullable
    public static BGFXTransform createSafe(long address) {
        return address == 0L ? null : new BGFXTransform(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)BGFXTransform.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransform.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXTransform mallocStack() {
        return BGFXTransform.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransform callocStack() {
        return BGFXTransform.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransform mallocStack(MemoryStack stack) {
        return BGFXTransform.malloc(stack);
    }

    @Deprecated
    public static BGFXTransform callocStack(MemoryStack stack) {
        return BGFXTransform.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXTransform.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXTransform.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransform.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransform.calloc(capacity, stack);
    }

    public static BGFXTransform malloc(MemoryStack stack) {
        return new BGFXTransform(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXTransform calloc(MemoryStack stack) {
        return new BGFXTransform(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer ndata(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)(Short.toUnsignedInt(BGFXTransform.nnum(struct)) << 4));
    }

    public static short nnum(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUM);
    }

    static {
        Struct.Layout layout = BGFXTransform.__struct((Struct.Member[])new Struct.Member[]{BGFXTransform.__member((int)POINTER_SIZE), BGFXTransform.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransform, Buffer>
    implements NativeResource {
        private static final BGFXTransform ELEMENT_FACTORY = BGFXTransform.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXTransform getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer data() {
            return BGFXTransform.ndata(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXTransform.nnum(this.address());
        }
    }
}

