/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transient_vertex_buffer_t")
public class BGFXTransientVertexBuffer
extends Struct<BGFXTransientVertexBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STARTVERTEX;
    public static final int STRIDE;
    public static final int HANDLE;
    public static final int LAYOUTHANDLE;

    protected BGFXTransientVertexBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXTransientVertexBuffer create(long address, @Nullable ByteBuffer container) {
        return new BGFXTransientVertexBuffer(address, container);
    }

    public BGFXTransientVertexBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXTransientVertexBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXTransientVertexBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXTransientVertexBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int startVertex() {
        return BGFXTransientVertexBuffer.nstartVertex(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXTransientVertexBuffer.nstride(this.address());
    }

    @NativeType(value="bgfx_vertex_buffer_handle_t")
    public short handle() {
        return BGFXTransientVertexBuffer.nhandle(this.address());
    }

    @NativeType(value="bgfx_vertex_layout_handle_t")
    public short layoutHandle() {
        return BGFXTransientVertexBuffer.nlayoutHandle(this.address());
    }

    public BGFXTransientVertexBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXTransientVertexBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer startVertex(@NativeType(value="uint32_t") int value) {
        BGFXTransientVertexBuffer.nstartVertex(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer stride(@NativeType(value="uint16_t") short value) {
        BGFXTransientVertexBuffer.nstride(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
        BGFXTransientVertexBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer layoutHandle(@NativeType(value="bgfx_vertex_layout_handle_t") short value) {
        BGFXTransientVertexBuffer.nlayoutHandle(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer set(ByteBuffer data, int startVertex, short stride, short handle, short layoutHandle) {
        this.data(data);
        this.startVertex(startVertex);
        this.stride(stride);
        this.handle(handle);
        this.layoutHandle(layoutHandle);
        return this;
    }

    public BGFXTransientVertexBuffer set(BGFXTransientVertexBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXTransientVertexBuffer malloc() {
        return new BGFXTransientVertexBuffer(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXTransientVertexBuffer calloc() {
        return new BGFXTransientVertexBuffer(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXTransientVertexBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXTransientVertexBuffer(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXTransientVertexBuffer create(long address) {
        return new BGFXTransientVertexBuffer(address, null);
    }

    @Nullable
    public static BGFXTransientVertexBuffer createSafe(long address) {
        return address == 0L ? null : new BGFXTransientVertexBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)BGFXTransientVertexBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransientVertexBuffer.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXTransientVertexBuffer mallocStack() {
        return BGFXTransientVertexBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransientVertexBuffer callocStack() {
        return BGFXTransientVertexBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransientVertexBuffer mallocStack(MemoryStack stack) {
        return BGFXTransientVertexBuffer.malloc(stack);
    }

    @Deprecated
    public static BGFXTransientVertexBuffer callocStack(MemoryStack stack) {
        return BGFXTransientVertexBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXTransientVertexBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXTransientVertexBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransientVertexBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransientVertexBuffer.calloc(capacity, stack);
    }

    public static BGFXTransientVertexBuffer malloc(MemoryStack stack) {
        return new BGFXTransientVertexBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXTransientVertexBuffer calloc(MemoryStack stack) {
        return new BGFXTransientVertexBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)BGFXTransientVertexBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int nstartVertex(long struct) {
        return UNSAFE.getInt(null, struct + (long)STARTVERTEX);
    }

    public static short nstride(long struct) {
        return UNSAFE.getShort(null, struct + (long)STRIDE);
    }

    public static short nhandle(long struct) {
        return UNSAFE.getShort(null, struct + (long)HANDLE);
    }

    public static short nlayoutHandle(long struct) {
        return UNSAFE.getShort(null, struct + (long)LAYOUTHANDLE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        BGFXTransientVertexBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void nstartVertex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STARTVERTEX, value);
    }

    public static void nstride(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)STRIDE, value);
    }

    public static void nhandle(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)HANDLE, value);
    }

    public static void nlayoutHandle(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)LAYOUTHANDLE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = BGFXTransientVertexBuffer.__struct((Struct.Member[])new Struct.Member[]{BGFXTransientVertexBuffer.__member((int)POINTER_SIZE), BGFXTransientVertexBuffer.__member((int)4), BGFXTransientVertexBuffer.__member((int)4), BGFXTransientVertexBuffer.__member((int)2), BGFXTransientVertexBuffer.__member((int)2), BGFXTransientVertexBuffer.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STARTVERTEX = layout.offsetof(2);
        STRIDE = layout.offsetof(3);
        HANDLE = layout.offsetof(4);
        LAYOUTHANDLE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransientVertexBuffer, Buffer>
    implements NativeResource {
        private static final BGFXTransientVertexBuffer ELEMENT_FACTORY = BGFXTransientVertexBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXTransientVertexBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXTransientVertexBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXTransientVertexBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int startVertex() {
            return BGFXTransientVertexBuffer.nstartVertex(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXTransientVertexBuffer.nstride(this.address());
        }

        @NativeType(value="bgfx_vertex_buffer_handle_t")
        public short handle() {
            return BGFXTransientVertexBuffer.nhandle(this.address());
        }

        @NativeType(value="bgfx_vertex_layout_handle_t")
        public short layoutHandle() {
            return BGFXTransientVertexBuffer.nlayoutHandle(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXTransientVertexBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer startVertex(@NativeType(value="uint32_t") int value) {
            BGFXTransientVertexBuffer.nstartVertex(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXTransientVertexBuffer.nstride(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
            BGFXTransientVertexBuffer.nhandle(this.address(), value);
            return this;
        }

        public Buffer layoutHandle(@NativeType(value="bgfx_vertex_layout_handle_t") short value) {
            BGFXTransientVertexBuffer.nlayoutHandle(this.address(), value);
            return this;
        }
    }
}

