/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_ARRAY3D_DESCRIPTOR
extends Struct<CUDA_ARRAY3D_DESCRIPTOR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int FORMAT;
    public static final int NUMCHANNELS;
    public static final int FLAGS;

    protected CUDA_ARRAY3D_DESCRIPTOR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_ARRAY3D_DESCRIPTOR create(long address, @Nullable ByteBuffer container) {
        return new CUDA_ARRAY3D_DESCRIPTOR(address, container);
    }

    public CUDA_ARRAY3D_DESCRIPTOR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_ARRAY3D_DESCRIPTOR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long Width() {
        return CUDA_ARRAY3D_DESCRIPTOR.nWidth(this.address());
    }

    @NativeType(value="size_t")
    public long Height() {
        return CUDA_ARRAY3D_DESCRIPTOR.nHeight(this.address());
    }

    @NativeType(value="size_t")
    public long Depth() {
        return CUDA_ARRAY3D_DESCRIPTOR.nDepth(this.address());
    }

    @NativeType(value="CUarray_format")
    public int Format() {
        return CUDA_ARRAY3D_DESCRIPTOR.nFormat(this.address());
    }

    @NativeType(value="unsigned int")
    public int NumChannels() {
        return CUDA_ARRAY3D_DESCRIPTOR.nNumChannels(this.address());
    }

    @NativeType(value="unsigned int")
    public int Flags() {
        return CUDA_ARRAY3D_DESCRIPTOR.nFlags(this.address());
    }

    public CUDA_ARRAY3D_DESCRIPTOR Width(@NativeType(value="size_t") long value) {
        CUDA_ARRAY3D_DESCRIPTOR.nWidth(this.address(), value);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR Height(@NativeType(value="size_t") long value) {
        CUDA_ARRAY3D_DESCRIPTOR.nHeight(this.address(), value);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR Depth(@NativeType(value="size_t") long value) {
        CUDA_ARRAY3D_DESCRIPTOR.nDepth(this.address(), value);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR Format(@NativeType(value="CUarray_format") int value) {
        CUDA_ARRAY3D_DESCRIPTOR.nFormat(this.address(), value);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR NumChannels(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY3D_DESCRIPTOR.nNumChannels(this.address(), value);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR Flags(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY3D_DESCRIPTOR.nFlags(this.address(), value);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR set(long Width, long Height, long Depth, int Format, int NumChannels, int Flags) {
        this.Width(Width);
        this.Height(Height);
        this.Depth(Depth);
        this.Format(Format);
        this.NumChannels(NumChannels);
        this.Flags(Flags);
        return this;
    }

    public CUDA_ARRAY3D_DESCRIPTOR set(CUDA_ARRAY3D_DESCRIPTOR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_ARRAY3D_DESCRIPTOR malloc() {
        return new CUDA_ARRAY3D_DESCRIPTOR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_ARRAY3D_DESCRIPTOR calloc() {
        return new CUDA_ARRAY3D_DESCRIPTOR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_ARRAY3D_DESCRIPTOR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_ARRAY3D_DESCRIPTOR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_ARRAY3D_DESCRIPTOR create(long address) {
        return new CUDA_ARRAY3D_DESCRIPTOR(address, null);
    }

    @Nullable
    public static CUDA_ARRAY3D_DESCRIPTOR createSafe(long address) {
        return address == 0L ? null : new CUDA_ARRAY3D_DESCRIPTOR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_ARRAY3D_DESCRIPTOR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_ARRAY3D_DESCRIPTOR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_ARRAY3D_DESCRIPTOR mallocStack() {
        return CUDA_ARRAY3D_DESCRIPTOR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_ARRAY3D_DESCRIPTOR callocStack() {
        return CUDA_ARRAY3D_DESCRIPTOR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_ARRAY3D_DESCRIPTOR mallocStack(MemoryStack stack) {
        return CUDA_ARRAY3D_DESCRIPTOR.malloc(stack);
    }

    @Deprecated
    public static CUDA_ARRAY3D_DESCRIPTOR callocStack(MemoryStack stack) {
        return CUDA_ARRAY3D_DESCRIPTOR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_ARRAY3D_DESCRIPTOR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_ARRAY3D_DESCRIPTOR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_ARRAY3D_DESCRIPTOR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_ARRAY3D_DESCRIPTOR.calloc(capacity, stack);
    }

    public static CUDA_ARRAY3D_DESCRIPTOR malloc(MemoryStack stack) {
        return new CUDA_ARRAY3D_DESCRIPTOR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_ARRAY3D_DESCRIPTOR calloc(MemoryStack stack) {
        return new CUDA_ARRAY3D_DESCRIPTOR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nWidth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIDTH));
    }

    public static long nHeight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HEIGHT));
    }

    public static long nDepth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEPTH));
    }

    public static int nFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nNumChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMCHANNELS);
    }

    public static int nFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nWidth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIDTH), (long)value);
    }

    public static void nHeight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HEIGHT), (long)value);
    }

    public static void nDepth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEPTH), (long)value);
    }

    public static void nFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nNumChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMCHANNELS, value);
    }

    public static void nFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = CUDA_ARRAY3D_DESCRIPTOR.__struct((Struct.Member[])new Struct.Member[]{CUDA_ARRAY3D_DESCRIPTOR.__member((int)POINTER_SIZE), CUDA_ARRAY3D_DESCRIPTOR.__member((int)POINTER_SIZE), CUDA_ARRAY3D_DESCRIPTOR.__member((int)POINTER_SIZE), CUDA_ARRAY3D_DESCRIPTOR.__member((int)4), CUDA_ARRAY3D_DESCRIPTOR.__member((int)4), CUDA_ARRAY3D_DESCRIPTOR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
        FORMAT = layout.offsetof(3);
        NUMCHANNELS = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CUDA_ARRAY3D_DESCRIPTOR, Buffer>
    implements NativeResource {
        private static final CUDA_ARRAY3D_DESCRIPTOR ELEMENT_FACTORY = CUDA_ARRAY3D_DESCRIPTOR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_ARRAY3D_DESCRIPTOR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long Width() {
            return CUDA_ARRAY3D_DESCRIPTOR.nWidth(this.address());
        }

        @NativeType(value="size_t")
        public long Height() {
            return CUDA_ARRAY3D_DESCRIPTOR.nHeight(this.address());
        }

        @NativeType(value="size_t")
        public long Depth() {
            return CUDA_ARRAY3D_DESCRIPTOR.nDepth(this.address());
        }

        @NativeType(value="CUarray_format")
        public int Format() {
            return CUDA_ARRAY3D_DESCRIPTOR.nFormat(this.address());
        }

        @NativeType(value="unsigned int")
        public int NumChannels() {
            return CUDA_ARRAY3D_DESCRIPTOR.nNumChannels(this.address());
        }

        @NativeType(value="unsigned int")
        public int Flags() {
            return CUDA_ARRAY3D_DESCRIPTOR.nFlags(this.address());
        }

        public Buffer Width(@NativeType(value="size_t") long value) {
            CUDA_ARRAY3D_DESCRIPTOR.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(@NativeType(value="size_t") long value) {
            CUDA_ARRAY3D_DESCRIPTOR.nHeight(this.address(), value);
            return this;
        }

        public Buffer Depth(@NativeType(value="size_t") long value) {
            CUDA_ARRAY3D_DESCRIPTOR.nDepth(this.address(), value);
            return this;
        }

        public Buffer Format(@NativeType(value="CUarray_format") int value) {
            CUDA_ARRAY3D_DESCRIPTOR.nFormat(this.address(), value);
            return this;
        }

        public Buffer NumChannels(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY3D_DESCRIPTOR.nNumChannels(this.address(), value);
            return this;
        }

        public Buffer Flags(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY3D_DESCRIPTOR.nFlags(this.address(), value);
            return this;
        }
    }
}

