/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_ARRAY_DESCRIPTOR
extends Struct<CUDA_ARRAY_DESCRIPTOR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int FORMAT;
    public static final int NUMCHANNELS;

    protected CUDA_ARRAY_DESCRIPTOR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_ARRAY_DESCRIPTOR create(long address, @Nullable ByteBuffer container) {
        return new CUDA_ARRAY_DESCRIPTOR(address, container);
    }

    public CUDA_ARRAY_DESCRIPTOR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_ARRAY_DESCRIPTOR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long Width() {
        return CUDA_ARRAY_DESCRIPTOR.nWidth(this.address());
    }

    @NativeType(value="size_t")
    public long Height() {
        return CUDA_ARRAY_DESCRIPTOR.nHeight(this.address());
    }

    @NativeType(value="CUarray_format")
    public int Format() {
        return CUDA_ARRAY_DESCRIPTOR.nFormat(this.address());
    }

    @NativeType(value="unsigned int")
    public int NumChannels() {
        return CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address());
    }

    public CUDA_ARRAY_DESCRIPTOR Width(@NativeType(value="size_t") long value) {
        CUDA_ARRAY_DESCRIPTOR.nWidth(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR Height(@NativeType(value="size_t") long value) {
        CUDA_ARRAY_DESCRIPTOR.nHeight(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR Format(@NativeType(value="CUarray_format") int value) {
        CUDA_ARRAY_DESCRIPTOR.nFormat(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR NumChannels(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR set(long Width, long Height, int Format, int NumChannels) {
        this.Width(Width);
        this.Height(Height);
        this.Format(Format);
        this.NumChannels(NumChannels);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR set(CUDA_ARRAY_DESCRIPTOR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_ARRAY_DESCRIPTOR malloc() {
        return new CUDA_ARRAY_DESCRIPTOR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_ARRAY_DESCRIPTOR calloc() {
        return new CUDA_ARRAY_DESCRIPTOR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_ARRAY_DESCRIPTOR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_ARRAY_DESCRIPTOR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_ARRAY_DESCRIPTOR create(long address) {
        return new CUDA_ARRAY_DESCRIPTOR(address, null);
    }

    @Nullable
    public static CUDA_ARRAY_DESCRIPTOR createSafe(long address) {
        return address == 0L ? null : new CUDA_ARRAY_DESCRIPTOR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_ARRAY_DESCRIPTOR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_ARRAY_DESCRIPTOR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR mallocStack() {
        return CUDA_ARRAY_DESCRIPTOR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR callocStack() {
        return CUDA_ARRAY_DESCRIPTOR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR mallocStack(MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.malloc(stack);
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR callocStack(MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.calloc(capacity, stack);
    }

    public static CUDA_ARRAY_DESCRIPTOR malloc(MemoryStack stack) {
        return new CUDA_ARRAY_DESCRIPTOR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_ARRAY_DESCRIPTOR calloc(MemoryStack stack) {
        return new CUDA_ARRAY_DESCRIPTOR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nWidth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIDTH));
    }

    public static long nHeight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HEIGHT));
    }

    public static int nFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nNumChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMCHANNELS);
    }

    public static void nWidth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIDTH), (long)value);
    }

    public static void nHeight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HEIGHT), (long)value);
    }

    public static void nFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nNumChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMCHANNELS, value);
    }

    static {
        Struct.Layout layout = CUDA_ARRAY_DESCRIPTOR.__struct((Struct.Member[])new Struct.Member[]{CUDA_ARRAY_DESCRIPTOR.__member((int)POINTER_SIZE), CUDA_ARRAY_DESCRIPTOR.__member((int)POINTER_SIZE), CUDA_ARRAY_DESCRIPTOR.__member((int)4), CUDA_ARRAY_DESCRIPTOR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
        NUMCHANNELS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUDA_ARRAY_DESCRIPTOR, Buffer>
    implements NativeResource {
        private static final CUDA_ARRAY_DESCRIPTOR ELEMENT_FACTORY = CUDA_ARRAY_DESCRIPTOR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_ARRAY_DESCRIPTOR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long Width() {
            return CUDA_ARRAY_DESCRIPTOR.nWidth(this.address());
        }

        @NativeType(value="size_t")
        public long Height() {
            return CUDA_ARRAY_DESCRIPTOR.nHeight(this.address());
        }

        @NativeType(value="CUarray_format")
        public int Format() {
            return CUDA_ARRAY_DESCRIPTOR.nFormat(this.address());
        }

        @NativeType(value="unsigned int")
        public int NumChannels() {
            return CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address());
        }

        public Buffer Width(@NativeType(value="size_t") long value) {
            CUDA_ARRAY_DESCRIPTOR.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(@NativeType(value="size_t") long value) {
            CUDA_ARRAY_DESCRIPTOR.nHeight(this.address(), value);
            return this;
        }

        public Buffer Format(@NativeType(value="CUarray_format") int value) {
            CUDA_ARRAY_DESCRIPTOR.nFormat(this.address(), value);
            return this;
        }

        public Buffer NumChannels(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address(), value);
            return this;
        }
    }
}

