/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUhostFn;
import org.lwjgl.cuda.CUhostFnI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_HOST_NODE_PARAMS
extends Struct<CUDA_HOST_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FN;
    public static final int USERDATA;

    protected CUDA_HOST_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_HOST_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_HOST_NODE_PARAMS(address, container);
    }

    public CUDA_HOST_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_HOST_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void (*) (void *)")
    public CUhostFn fn() {
        return CUDA_HOST_NODE_PARAMS.nfn(this.address());
    }

    @NativeType(value="void *")
    public long userData() {
        return CUDA_HOST_NODE_PARAMS.nuserData(this.address());
    }

    public CUDA_HOST_NODE_PARAMS fn(@NativeType(value="void (*) (void *)") CUhostFnI value) {
        CUDA_HOST_NODE_PARAMS.nfn(this.address(), value);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS userData(@NativeType(value="void *") long value) {
        CUDA_HOST_NODE_PARAMS.nuserData(this.address(), value);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS set(CUhostFnI fn, long userData) {
        this.fn(fn);
        this.userData(userData);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS set(CUDA_HOST_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_HOST_NODE_PARAMS malloc() {
        return new CUDA_HOST_NODE_PARAMS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_HOST_NODE_PARAMS calloc() {
        return new CUDA_HOST_NODE_PARAMS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_HOST_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_HOST_NODE_PARAMS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_HOST_NODE_PARAMS create(long address) {
        return new CUDA_HOST_NODE_PARAMS(address, null);
    }

    @Nullable
    public static CUDA_HOST_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_HOST_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_HOST_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_HOST_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_HOST_NODE_PARAMS mallocStack() {
        return CUDA_HOST_NODE_PARAMS.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_HOST_NODE_PARAMS callocStack() {
        return CUDA_HOST_NODE_PARAMS.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_HOST_NODE_PARAMS mallocStack(MemoryStack stack) {
        return CUDA_HOST_NODE_PARAMS.malloc(stack);
    }

    @Deprecated
    public static CUDA_HOST_NODE_PARAMS callocStack(MemoryStack stack) {
        return CUDA_HOST_NODE_PARAMS.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_HOST_NODE_PARAMS.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_HOST_NODE_PARAMS.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_HOST_NODE_PARAMS.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_HOST_NODE_PARAMS.calloc(capacity, stack);
    }

    public static CUDA_HOST_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_HOST_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_HOST_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_HOST_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUhostFn nfn(long struct) {
        return CUhostFn.create(MemoryUtil.memGetAddress((long)(struct + (long)FN)));
    }

    public static long nuserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static void nfn(long struct, CUhostFnI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FN), (long)value.address());
    }

    public static void nuserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FN)));
    }

    static {
        Struct.Layout layout = CUDA_HOST_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_HOST_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_HOST_NODE_PARAMS.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FN = layout.offsetof(0);
        USERDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUDA_HOST_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_HOST_NODE_PARAMS ELEMENT_FACTORY = CUDA_HOST_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_HOST_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void (*) (void *)")
        public CUhostFn fn() {
            return CUDA_HOST_NODE_PARAMS.nfn(this.address());
        }

        @NativeType(value="void *")
        public long userData() {
            return CUDA_HOST_NODE_PARAMS.nuserData(this.address());
        }

        public Buffer fn(@NativeType(value="void (*) (void *)") CUhostFnI value) {
            CUDA_HOST_NODE_PARAMS.nfn(this.address(), value);
            return this;
        }

        public Buffer userData(@NativeType(value="void *") long value) {
            CUDA_HOST_NODE_PARAMS.nuserData(this.address(), value);
            return this;
        }
    }
}

