/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEMSET_NODE_PARAMS
extends Struct<CUDA_MEMSET_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DST;
    public static final int PITCH;
    public static final int VALUE;
    public static final int ELEMENTSIZE;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected CUDA_MEMSET_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_MEMSET_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_MEMSET_NODE_PARAMS(address, container);
    }

    public CUDA_MEMSET_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_MEMSET_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUdeviceptr")
    public long dst() {
        return CUDA_MEMSET_NODE_PARAMS.ndst(this.address());
    }

    @NativeType(value="size_t")
    public long pitch() {
        return CUDA_MEMSET_NODE_PARAMS.npitch(this.address());
    }

    @NativeType(value="unsigned int")
    public int value() {
        return CUDA_MEMSET_NODE_PARAMS.nvalue(this.address());
    }

    @NativeType(value="unsigned int")
    public int elementSize() {
        return CUDA_MEMSET_NODE_PARAMS.nelementSize(this.address());
    }

    @NativeType(value="size_t")
    public long width() {
        return CUDA_MEMSET_NODE_PARAMS.nwidth(this.address());
    }

    @NativeType(value="size_t")
    public long height() {
        return CUDA_MEMSET_NODE_PARAMS.nheight(this.address());
    }

    public CUDA_MEMSET_NODE_PARAMS dst(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMSET_NODE_PARAMS.ndst(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS pitch(@NativeType(value="size_t") long value) {
        CUDA_MEMSET_NODE_PARAMS.npitch(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS value(@NativeType(value="unsigned int") int value) {
        CUDA_MEMSET_NODE_PARAMS.nvalue(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS elementSize(@NativeType(value="unsigned int") int value) {
        CUDA_MEMSET_NODE_PARAMS.nelementSize(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS width(@NativeType(value="size_t") long value) {
        CUDA_MEMSET_NODE_PARAMS.nwidth(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS height(@NativeType(value="size_t") long value) {
        CUDA_MEMSET_NODE_PARAMS.nheight(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS set(long dst, long pitch, int value, int elementSize, long width, long height) {
        this.dst(dst);
        this.pitch(pitch);
        this.value(value);
        this.elementSize(elementSize);
        this.width(width);
        this.height(height);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS set(CUDA_MEMSET_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_MEMSET_NODE_PARAMS malloc() {
        return new CUDA_MEMSET_NODE_PARAMS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_MEMSET_NODE_PARAMS calloc() {
        return new CUDA_MEMSET_NODE_PARAMS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_MEMSET_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_MEMSET_NODE_PARAMS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_MEMSET_NODE_PARAMS create(long address) {
        return new CUDA_MEMSET_NODE_PARAMS(address, null);
    }

    @Nullable
    public static CUDA_MEMSET_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_MEMSET_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_MEMSET_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEMSET_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_MEMSET_NODE_PARAMS mallocStack() {
        return CUDA_MEMSET_NODE_PARAMS.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMSET_NODE_PARAMS callocStack() {
        return CUDA_MEMSET_NODE_PARAMS.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMSET_NODE_PARAMS mallocStack(MemoryStack stack) {
        return CUDA_MEMSET_NODE_PARAMS.malloc(stack);
    }

    @Deprecated
    public static CUDA_MEMSET_NODE_PARAMS callocStack(MemoryStack stack) {
        return CUDA_MEMSET_NODE_PARAMS.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_MEMSET_NODE_PARAMS.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_MEMSET_NODE_PARAMS.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMSET_NODE_PARAMS.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMSET_NODE_PARAMS.calloc(capacity, stack);
    }

    public static CUDA_MEMSET_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_MEMSET_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_MEMSET_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_MEMSET_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndst(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DST));
    }

    public static long npitch(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PITCH));
    }

    public static int nvalue(long struct) {
        return UNSAFE.getInt(null, struct + (long)VALUE);
    }

    public static int nelementSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)ELEMENTSIZE);
    }

    public static long nwidth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIDTH));
    }

    public static long nheight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HEIGHT));
    }

    public static void ndst(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DST), (long)Checks.check((long)value));
    }

    public static void npitch(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PITCH), (long)value);
    }

    public static void nvalue(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VALUE, value);
    }

    public static void nelementSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ELEMENTSIZE, value);
    }

    public static void nwidth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIDTH), (long)value);
    }

    public static void nheight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HEIGHT), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DST)));
    }

    static {
        Struct.Layout layout = CUDA_MEMSET_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_MEMSET_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS.__member((int)4), CUDA_MEMSET_NODE_PARAMS.__member((int)4), CUDA_MEMSET_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DST = layout.offsetof(0);
        PITCH = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        ELEMENTSIZE = layout.offsetof(3);
        WIDTH = layout.offsetof(4);
        HEIGHT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEMSET_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_MEMSET_NODE_PARAMS ELEMENT_FACTORY = CUDA_MEMSET_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_MEMSET_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUdeviceptr")
        public long dst() {
            return CUDA_MEMSET_NODE_PARAMS.ndst(this.address());
        }

        @NativeType(value="size_t")
        public long pitch() {
            return CUDA_MEMSET_NODE_PARAMS.npitch(this.address());
        }

        @NativeType(value="unsigned int")
        public int value() {
            return CUDA_MEMSET_NODE_PARAMS.nvalue(this.address());
        }

        @NativeType(value="unsigned int")
        public int elementSize() {
            return CUDA_MEMSET_NODE_PARAMS.nelementSize(this.address());
        }

        @NativeType(value="size_t")
        public long width() {
            return CUDA_MEMSET_NODE_PARAMS.nwidth(this.address());
        }

        @NativeType(value="size_t")
        public long height() {
            return CUDA_MEMSET_NODE_PARAMS.nheight(this.address());
        }

        public Buffer dst(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMSET_NODE_PARAMS.ndst(this.address(), value);
            return this;
        }

        public Buffer pitch(@NativeType(value="size_t") long value) {
            CUDA_MEMSET_NODE_PARAMS.npitch(this.address(), value);
            return this;
        }

        public Buffer value(@NativeType(value="unsigned int") int value) {
            CUDA_MEMSET_NODE_PARAMS.nvalue(this.address(), value);
            return this;
        }

        public Buffer elementSize(@NativeType(value="unsigned int") int value) {
            CUDA_MEMSET_NODE_PARAMS.nelementSize(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="size_t") long value) {
            CUDA_MEMSET_NODE_PARAMS.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="size_t") long value) {
            CUDA_MEMSET_NODE_PARAMS.nheight(this.address(), value);
            return this;
        }
    }
}

