/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class CUGL {
    public static final int CU_GL_DEVICE_LIST_ALL = 1;
    public static final int CU_GL_DEVICE_LIST_CURRENT_FRAME = 2;
    public static final int CU_GL_DEVICE_LIST_NEXT_FRAME = 3;
    public static final int CU_GL_MAP_RESOURCE_FLAGS_NONE = 1;
    public static final int CU_GL_MAP_RESOURCE_FLAGS_READ_ONLY = 2;
    public static final int CU_GL_MAP_RESOURCE_FLAGS_WRITE_DISCARD = 3;

    protected CUGL() {
        throw new UnsupportedOperationException();
    }

    public static int ncuGraphicsGLRegisterBuffer(long pCudaResource, int buffer, int Flags) {
        long __functionAddress = Functions.GraphicsGLRegisterBuffer;
        return JNI.callPI((long)pCudaResource, (int)buffer, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsGLRegisterBuffer(@NativeType(value="CUgraphicsResource *") PointerBuffer pCudaResource, @NativeType(value="GLuint") int buffer, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pCudaResource, (int)1);
        }
        return CUGL.ncuGraphicsGLRegisterBuffer(MemoryUtil.memAddress((CustomBuffer)pCudaResource), buffer, Flags);
    }

    public static int ncuGraphicsGLRegisterImage(long pCudaResource, int image, int target, int Flags) {
        long __functionAddress = Functions.GraphicsGLRegisterImage;
        return JNI.callPI((long)pCudaResource, (int)image, (int)target, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsGLRegisterImage(@NativeType(value="CUgraphicsResource *") PointerBuffer pCudaResource, @NativeType(value="GLuint") int image, @NativeType(value="GLenum") int target, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pCudaResource, (int)1);
        }
        return CUGL.ncuGraphicsGLRegisterImage(MemoryUtil.memAddress((CustomBuffer)pCudaResource), image, target, Flags);
    }

    public static int ncuGLGetDevices(long pCudaDeviceCount, long pCudaDevices, int cudaDeviceCount, int deviceList) {
        long __functionAddress = Functions.GLGetDevices;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pCudaDeviceCount, (long)pCudaDevices, (int)cudaDeviceCount, (int)deviceList, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLGetDevices(@NativeType(value="unsigned int *") IntBuffer pCudaDeviceCount, @NativeType(value="CUdevice *") IntBuffer pCudaDevices, @NativeType(value="CUGLDeviceList") int deviceList) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCudaDeviceCount, (int)1);
        }
        return CUGL.ncuGLGetDevices(MemoryUtil.memAddress((IntBuffer)pCudaDeviceCount), MemoryUtil.memAddress((IntBuffer)pCudaDevices), pCudaDevices.remaining(), deviceList);
    }

    public static int ncuGLCtxCreate(long pCtx, int Flags, int device) {
        long __functionAddress = Functions.GLCtxCreate;
        return JNI.callPI((long)pCtx, (int)Flags, (int)device, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLCtxCreate(@NativeType(value="CUcontext *") PointerBuffer pCtx, @NativeType(value="unsigned int") int Flags, @NativeType(value="CUdevice") int device) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pCtx, (int)1);
        }
        return CUGL.ncuGLCtxCreate(MemoryUtil.memAddress((CustomBuffer)pCtx), Flags, device);
    }

    @NativeType(value="CUresult")
    public static int cuGLInit() {
        long __functionAddress = Functions.GLInit;
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLRegisterBufferObject(@NativeType(value="GLuint") int buffer) {
        long __functionAddress = Functions.GLRegisterBufferObject;
        return JNI.callI((int)buffer, (long)__functionAddress);
    }

    public static int ncuGLMapBufferObject(long dptr, long size, int buffer) {
        long __functionAddress = Functions.GLMapBufferObject;
        return JNI.callPPI((long)dptr, (long)size, (int)buffer, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLMapBufferObject(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t *") PointerBuffer size, @NativeType(value="GLuint") int buffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dptr, (int)1);
            Checks.check((CustomBuffer)size, (int)1);
        }
        return CUGL.ncuGLMapBufferObject(MemoryUtil.memAddress((CustomBuffer)dptr), MemoryUtil.memAddress((CustomBuffer)size), buffer);
    }

    @NativeType(value="CUresult")
    public static int cuGLUnmapBufferObject(@NativeType(value="GLuint") int buffer) {
        long __functionAddress = Functions.GLUnmapBufferObject;
        return JNI.callI((int)buffer, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLUnregisterBufferObject(@NativeType(value="GLuint") int buffer) {
        long __functionAddress = Functions.GLUnregisterBufferObject;
        return JNI.callI((int)buffer, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLSetBufferObjectMapFlags(@NativeType(value="GLuint") int buffer, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.GLSetBufferObjectMapFlags;
        return JNI.callI((int)buffer, (int)Flags, (long)__functionAddress);
    }

    public static int ncuGLMapBufferObjectAsync(long dptr, long size, int buffer, long hStream) {
        long __functionAddress = Functions.GLMapBufferObjectAsync;
        return JNI.callPPPI((long)dptr, (long)size, (int)buffer, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLMapBufferObjectAsync(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t *") PointerBuffer size, @NativeType(value="GLuint") int buffer, @NativeType(value="CUstream") long hStream) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dptr, (int)1);
            Checks.check((CustomBuffer)size, (int)1);
        }
        return CUGL.ncuGLMapBufferObjectAsync(MemoryUtil.memAddress((CustomBuffer)dptr), MemoryUtil.memAddress((CustomBuffer)size), buffer, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuGLUnmapBufferObjectAsync(@NativeType(value="GLuint") int buffer, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.GLUnmapBufferObjectAsync;
        return JNI.callPI((int)buffer, (long)hStream, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GraphicsGLRegisterBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphicsGLRegisterBuffer");
        public static final long GraphicsGLRegisterImage = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphicsGLRegisterImage");
        public static final long GLGetDevices = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuGLGetDevices", 2));
        public static final long GLCtxCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuGLCtxCreate", 2));
        public static final long GLInit = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGLInit");
        public static final long GLRegisterBufferObject = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGLRegisterBufferObject");
        public static final long GLMapBufferObject = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuGLMapBufferObject", 2)));
        public static final long GLUnmapBufferObject = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGLUnmapBufferObject");
        public static final long GLUnregisterBufferObject = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGLUnregisterBufferObject");
        public static final long GLSetBufferObjectMapFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGLSetBufferObjectMapFlags");
        public static final long GLMapBufferObjectAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuGLMapBufferObjectAsync", 2)));
        public static final long GLUnmapBufferObjectAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGLUnmapBufferObjectAsync");

        private Functions() {
        }
    }
}

