/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUasyncNotificationInfo
extends Struct<CUasyncNotificationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int INFO;
    public static final int INFO_OVERBUDGET;
    public static final int INFO_OVERBUDGET_BYTESOVERBUDGET;

    protected CUasyncNotificationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUasyncNotificationInfo create(long address, @Nullable ByteBuffer container) {
        return new CUasyncNotificationInfo(address, container);
    }

    public CUasyncNotificationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUasyncNotificationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUasyncNotificationType")
    public int type() {
        return CUasyncNotificationInfo.ntype(this.address());
    }

    @NativeType(value="unsigned long long")
    public long info_overBudget_bytesOverBudget() {
        return CUasyncNotificationInfo.ninfo_overBudget_bytesOverBudget(this.address());
    }

    public CUasyncNotificationInfo type(@NativeType(value="CUasyncNotificationType") int value) {
        CUasyncNotificationInfo.ntype(this.address(), value);
        return this;
    }

    public CUasyncNotificationInfo info_overBudget_bytesOverBudget(@NativeType(value="unsigned long long") long value) {
        CUasyncNotificationInfo.ninfo_overBudget_bytesOverBudget(this.address(), value);
        return this;
    }

    public CUasyncNotificationInfo set(CUasyncNotificationInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUasyncNotificationInfo malloc() {
        return new CUasyncNotificationInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUasyncNotificationInfo calloc() {
        return new CUasyncNotificationInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUasyncNotificationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUasyncNotificationInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUasyncNotificationInfo create(long address) {
        return new CUasyncNotificationInfo(address, null);
    }

    @Nullable
    public static CUasyncNotificationInfo createSafe(long address) {
        return address == 0L ? null : new CUasyncNotificationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUasyncNotificationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUasyncNotificationInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUasyncNotificationInfo malloc(MemoryStack stack) {
        return new CUasyncNotificationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUasyncNotificationInfo calloc(MemoryStack stack) {
        return new CUasyncNotificationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long ninfo_overBudget_bytesOverBudget(long struct) {
        return UNSAFE.getLong(null, struct + (long)INFO_OVERBUDGET_BYTESOVERBUDGET);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ninfo_overBudget_bytesOverBudget(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)INFO_OVERBUDGET_BYTESOVERBUDGET, value);
    }

    static {
        Struct.Layout layout = CUasyncNotificationInfo.__struct((Struct.Member[])new Struct.Member[]{CUasyncNotificationInfo.__member((int)4), CUasyncNotificationInfo.__union((Struct.Member[])new Struct.Member[]{CUasyncNotificationInfo.__struct((Struct.Member[])new Struct.Member[]{CUasyncNotificationInfo.__member((int)8)})})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        INFO = layout.offsetof(1);
        INFO_OVERBUDGET = layout.offsetof(2);
        INFO_OVERBUDGET_BYTESOVERBUDGET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUasyncNotificationInfo, Buffer>
    implements NativeResource {
        private static final CUasyncNotificationInfo ELEMENT_FACTORY = CUasyncNotificationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUasyncNotificationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUasyncNotificationType")
        public int type() {
            return CUasyncNotificationInfo.ntype(this.address());
        }

        @NativeType(value="unsigned long long")
        public long info_overBudget_bytesOverBudget() {
            return CUasyncNotificationInfo.ninfo_overBudget_bytesOverBudget(this.address());
        }

        public Buffer type(@NativeType(value="CUasyncNotificationType") int value) {
            CUasyncNotificationInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer info_overBudget_bytesOverBudget(@NativeType(value="unsigned long long") long value) {
            CUasyncNotificationInfo.ninfo_overBudget_bytesOverBudget(this.address(), value);
            return this;
        }
    }
}

