/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUdevSmResource
extends Struct<CUdevSmResource> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SMCOUNT;

    protected CUdevSmResource(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUdevSmResource create(long address, @Nullable ByteBuffer container) {
        return new CUdevSmResource(address, container);
    }

    public CUdevSmResource(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUdevSmResource.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int smCount() {
        return CUdevSmResource.nsmCount(this.address());
    }

    public static CUdevSmResource create(long address) {
        return new CUdevSmResource(address, null);
    }

    @Nullable
    public static CUdevSmResource createSafe(long address) {
        return address == 0L ? null : new CUdevSmResource(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nsmCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SMCOUNT);
    }

    static {
        Struct.Layout layout = CUdevSmResource.__struct((Struct.Member[])new Struct.Member[]{CUdevSmResource.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SMCOUNT = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUdevSmResource, Buffer> {
        private static final CUdevSmResource ELEMENT_FACTORY = CUdevSmResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUdevSmResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int smCount() {
            return CUdevSmResource.nsmCount(this.address());
        }
    }
}

