/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemPoolPtrExportData
extends Struct<CUmemPoolPtrExportData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    protected CUmemPoolPtrExportData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUmemPoolPtrExportData create(long address, @Nullable ByteBuffer container) {
        return new CUmemPoolPtrExportData(address, container);
    }

    public CUmemPoolPtrExportData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUmemPoolPtrExportData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[64]")
    public ByteBuffer reserved() {
        return CUmemPoolPtrExportData.nreserved(this.address());
    }

    @NativeType(value="unsigned char")
    public byte reserved(int index) {
        return CUmemPoolPtrExportData.nreserved(this.address(), index);
    }

    public CUmemPoolPtrExportData reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
        CUmemPoolPtrExportData.nreserved(this.address(), value);
        return this;
    }

    public CUmemPoolPtrExportData reserved(int index, @NativeType(value="unsigned char") byte value) {
        CUmemPoolPtrExportData.nreserved(this.address(), index, value);
        return this;
    }

    public CUmemPoolPtrExportData set(CUmemPoolPtrExportData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUmemPoolPtrExportData malloc() {
        return new CUmemPoolPtrExportData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUmemPoolPtrExportData calloc() {
        return new CUmemPoolPtrExportData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUmemPoolPtrExportData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUmemPoolPtrExportData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUmemPoolPtrExportData create(long address) {
        return new CUmemPoolPtrExportData(address, null);
    }

    @Nullable
    public static CUmemPoolPtrExportData createSafe(long address) {
        return address == 0L ? null : new CUmemPoolPtrExportData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUmemPoolPtrExportData.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemPoolPtrExportData.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmemPoolPtrExportData malloc(MemoryStack stack) {
        return new CUmemPoolPtrExportData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmemPoolPtrExportData calloc(MemoryStack stack) {
        return new CUmemPoolPtrExportData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED), (int)64);
    }

    public static byte nreserved(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED + Checks.check((int)index, (int)64) * 1L);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 1));
    }

    public static void nreserved(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED + Checks.check((int)index, (int)64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUmemPoolPtrExportData.__struct((Struct.Member[])new Struct.Member[]{CUmemPoolPtrExportData.__array((int)1, (int)64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUmemPoolPtrExportData, Buffer>
    implements NativeResource {
        private static final CUmemPoolPtrExportData ELEMENT_FACTORY = CUmemPoolPtrExportData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUmemPoolPtrExportData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[64]")
        public ByteBuffer reserved() {
            return CUmemPoolPtrExportData.nreserved(this.address());
        }

        @NativeType(value="unsigned char")
        public byte reserved(int index) {
            return CUmemPoolPtrExportData.nreserved(this.address(), index);
        }

        public Buffer reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
            CUmemPoolPtrExportData.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned char") byte value) {
            CUmemPoolPtrExportData.nreserved(this.address(), index, value);
            return this;
        }
    }
}

