/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DBMONEY
extends Struct<DBMONEY>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNYHIGH;
    public static final int MNYLOW;

    protected DBMONEY(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected DBMONEY create(long address, @Nullable ByteBuffer container) {
        return new DBMONEY(address, container);
    }

    public DBMONEY(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), DBMONEY.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int mnyhigh() {
        return DBMONEY.nmnyhigh(this.address());
    }

    @NativeType(value="ULONG")
    public int mnylow() {
        return DBMONEY.nmnylow(this.address());
    }

    public DBMONEY mnyhigh(@NativeType(value="LONG") int value) {
        DBMONEY.nmnyhigh(this.address(), value);
        return this;
    }

    public DBMONEY mnylow(@NativeType(value="ULONG") int value) {
        DBMONEY.nmnylow(this.address(), value);
        return this;
    }

    public DBMONEY set(int mnyhigh, int mnylow) {
        this.mnyhigh(mnyhigh);
        this.mnylow(mnylow);
        return this;
    }

    public DBMONEY set(DBMONEY src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static DBMONEY malloc() {
        return new DBMONEY(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static DBMONEY calloc() {
        return new DBMONEY(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static DBMONEY create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new DBMONEY(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static DBMONEY create(long address) {
        return new DBMONEY(address, null);
    }

    @Nullable
    public static DBMONEY createSafe(long address) {
        return address == 0L ? null : new DBMONEY(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)DBMONEY.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = DBMONEY.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static DBMONEY mallocStack() {
        return DBMONEY.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBMONEY callocStack() {
        return DBMONEY.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBMONEY mallocStack(MemoryStack stack) {
        return DBMONEY.malloc(stack);
    }

    @Deprecated
    public static DBMONEY callocStack(MemoryStack stack) {
        return DBMONEY.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return DBMONEY.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return DBMONEY.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DBMONEY.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DBMONEY.calloc(capacity, stack);
    }

    public static DBMONEY malloc(MemoryStack stack) {
        return new DBMONEY(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static DBMONEY calloc(MemoryStack stack) {
        return new DBMONEY(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmnyhigh(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNYHIGH);
    }

    public static int nmnylow(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNYLOW);
    }

    public static void nmnyhigh(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNYHIGH, value);
    }

    public static void nmnylow(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNYLOW, value);
    }

    static {
        Struct.Layout layout = DBMONEY.__struct((Struct.Member[])new Struct.Member[]{DBMONEY.__member((int)4), DBMONEY.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNYHIGH = layout.offsetof(0);
        MNYLOW = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<DBMONEY, Buffer>
    implements NativeResource {
        private static final DBMONEY ELEMENT_FACTORY = DBMONEY.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected DBMONEY getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LONG")
        public int mnyhigh() {
            return DBMONEY.nmnyhigh(this.address());
        }

        @NativeType(value="ULONG")
        public int mnylow() {
            return DBMONEY.nmnylow(this.address());
        }

        public Buffer mnyhigh(@NativeType(value="LONG") int value) {
            DBMONEY.nmnyhigh(this.address(), value);
            return this;
        }

        public Buffer mnylow(@NativeType(value="ULONG") int value) {
            DBMONEY.nmnylow(this.address(), value);
            return this;
        }
    }
}

