/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SQLPERF
extends Struct<SQLPERF>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TIMERRESOLUTION;
    public static final int SQLIDU;
    public static final int SQLIDUROWS;
    public static final int SQLSELECTS;
    public static final int SQLSELECTROWS;
    public static final int TRANSACTIONS;
    public static final int SQLPREPARES;
    public static final int EXECDIRECTS;
    public static final int SQLEXECUTES;
    public static final int CURSOROPENS;
    public static final int CURSORSIZE;
    public static final int CURSORUSED;
    public static final int PERCENTCURSORUSED;
    public static final int AVGFETCHTIME;
    public static final int AVGCURSORSIZE;
    public static final int AVGCURSORUSED;
    public static final int SQLFETCHTIME;
    public static final int SQLFETCHCOUNT;
    public static final int CURRENTSTMTCOUNT;
    public static final int MAXOPENSTMT;
    public static final int SUMOPENSTMT;
    public static final int CURRENTCONNECTIONCOUNT;
    public static final int MAXCONNECTIONSOPENED;
    public static final int SUMCONNECTIONSOPENED;
    public static final int SUMCONNECTIONTIME;
    public static final int AVGTIMEOPENED;
    public static final int SERVERRNDTRIPS;
    public static final int BUFFERSSENT;
    public static final int BUFFERSREC;
    public static final int BYTESSENT;
    public static final int BYTESREC;
    public static final int MSEXECUTIONTIME;
    public static final int MSNETWORKSERVERTIME;

    protected SQLPERF(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SQLPERF create(long address, @Nullable ByteBuffer container) {
        return new SQLPERF(address, container);
    }

    public SQLPERF(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SQLPERF.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int TimerResolution() {
        return SQLPERF.nTimerResolution(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLidu() {
        return SQLPERF.nSQLidu(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLiduRows() {
        return SQLPERF.nSQLiduRows(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLSelects() {
        return SQLPERF.nSQLSelects(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLSelectRows() {
        return SQLPERF.nSQLSelectRows(this.address());
    }

    @NativeType(value="DWORD")
    public int Transactions() {
        return SQLPERF.nTransactions(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLPrepares() {
        return SQLPERF.nSQLPrepares(this.address());
    }

    @NativeType(value="DWORD")
    public int ExecDirects() {
        return SQLPERF.nExecDirects(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLExecutes() {
        return SQLPERF.nSQLExecutes(this.address());
    }

    @NativeType(value="DWORD")
    public int CursorOpens() {
        return SQLPERF.nCursorOpens(this.address());
    }

    @NativeType(value="DWORD")
    public int CursorSize() {
        return SQLPERF.nCursorSize(this.address());
    }

    @NativeType(value="DWORD")
    public int CursorUsed() {
        return SQLPERF.nCursorUsed(this.address());
    }

    @NativeType(value="LDOUBLE")
    public double PercentCursorUsed() {
        return SQLPERF.nPercentCursorUsed(this.address());
    }

    @NativeType(value="LDOUBLE")
    public double AvgFetchTime() {
        return SQLPERF.nAvgFetchTime(this.address());
    }

    @NativeType(value="LDOUBLE")
    public double AvgCursorSize() {
        return SQLPERF.nAvgCursorSize(this.address());
    }

    @NativeType(value="LDOUBLE")
    public double AvgCursorUsed() {
        return SQLPERF.nAvgCursorUsed(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLFetchTime() {
        return SQLPERF.nSQLFetchTime(this.address());
    }

    @NativeType(value="DWORD")
    public int SQLFetchCount() {
        return SQLPERF.nSQLFetchCount(this.address());
    }

    @NativeType(value="DWORD")
    public int CurrentStmtCount() {
        return SQLPERF.nCurrentStmtCount(this.address());
    }

    @NativeType(value="DWORD")
    public int MaxOpenStmt() {
        return SQLPERF.nMaxOpenStmt(this.address());
    }

    @NativeType(value="DWORD")
    public int SumOpenStmt() {
        return SQLPERF.nSumOpenStmt(this.address());
    }

    @NativeType(value="DWORD")
    public int CurrentConnectionCount() {
        return SQLPERF.nCurrentConnectionCount(this.address());
    }

    @NativeType(value="DWORD")
    public int MaxConnectionsOpened() {
        return SQLPERF.nMaxConnectionsOpened(this.address());
    }

    @NativeType(value="DWORD")
    public int SumConnectionsOpened() {
        return SQLPERF.nSumConnectionsOpened(this.address());
    }

    @NativeType(value="DWORD")
    public int SumConnectiontime() {
        return SQLPERF.nSumConnectiontime(this.address());
    }

    @NativeType(value="LDOUBLE")
    public double AvgTimeOpened() {
        return SQLPERF.nAvgTimeOpened(this.address());
    }

    @NativeType(value="DWORD")
    public int ServerRndTrips() {
        return SQLPERF.nServerRndTrips(this.address());
    }

    @NativeType(value="DWORD")
    public int BuffersSent() {
        return SQLPERF.nBuffersSent(this.address());
    }

    @NativeType(value="DWORD")
    public int BuffersRec() {
        return SQLPERF.nBuffersRec(this.address());
    }

    @NativeType(value="DWORD")
    public int BytesSent() {
        return SQLPERF.nBytesSent(this.address());
    }

    @NativeType(value="DWORD")
    public int BytesRec() {
        return SQLPERF.nBytesRec(this.address());
    }

    @NativeType(value="DWORD")
    public int msExecutionTime() {
        return SQLPERF.nmsExecutionTime(this.address());
    }

    @NativeType(value="DWORD")
    public int msNetWorkServerTime() {
        return SQLPERF.nmsNetWorkServerTime(this.address());
    }

    public SQLPERF TimerResolution(@NativeType(value="DWORD") int value) {
        SQLPERF.nTimerResolution(this.address(), value);
        return this;
    }

    public SQLPERF SQLidu(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLidu(this.address(), value);
        return this;
    }

    public SQLPERF SQLiduRows(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLiduRows(this.address(), value);
        return this;
    }

    public SQLPERF SQLSelects(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLSelects(this.address(), value);
        return this;
    }

    public SQLPERF SQLSelectRows(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLSelectRows(this.address(), value);
        return this;
    }

    public SQLPERF Transactions(@NativeType(value="DWORD") int value) {
        SQLPERF.nTransactions(this.address(), value);
        return this;
    }

    public SQLPERF SQLPrepares(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLPrepares(this.address(), value);
        return this;
    }

    public SQLPERF ExecDirects(@NativeType(value="DWORD") int value) {
        SQLPERF.nExecDirects(this.address(), value);
        return this;
    }

    public SQLPERF SQLExecutes(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLExecutes(this.address(), value);
        return this;
    }

    public SQLPERF CursorOpens(@NativeType(value="DWORD") int value) {
        SQLPERF.nCursorOpens(this.address(), value);
        return this;
    }

    public SQLPERF CursorSize(@NativeType(value="DWORD") int value) {
        SQLPERF.nCursorSize(this.address(), value);
        return this;
    }

    public SQLPERF CursorUsed(@NativeType(value="DWORD") int value) {
        SQLPERF.nCursorUsed(this.address(), value);
        return this;
    }

    public SQLPERF PercentCursorUsed(@NativeType(value="LDOUBLE") double value) {
        SQLPERF.nPercentCursorUsed(this.address(), value);
        return this;
    }

    public SQLPERF AvgFetchTime(@NativeType(value="LDOUBLE") double value) {
        SQLPERF.nAvgFetchTime(this.address(), value);
        return this;
    }

    public SQLPERF AvgCursorSize(@NativeType(value="LDOUBLE") double value) {
        SQLPERF.nAvgCursorSize(this.address(), value);
        return this;
    }

    public SQLPERF AvgCursorUsed(@NativeType(value="LDOUBLE") double value) {
        SQLPERF.nAvgCursorUsed(this.address(), value);
        return this;
    }

    public SQLPERF SQLFetchTime(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLFetchTime(this.address(), value);
        return this;
    }

    public SQLPERF SQLFetchCount(@NativeType(value="DWORD") int value) {
        SQLPERF.nSQLFetchCount(this.address(), value);
        return this;
    }

    public SQLPERF CurrentStmtCount(@NativeType(value="DWORD") int value) {
        SQLPERF.nCurrentStmtCount(this.address(), value);
        return this;
    }

    public SQLPERF MaxOpenStmt(@NativeType(value="DWORD") int value) {
        SQLPERF.nMaxOpenStmt(this.address(), value);
        return this;
    }

    public SQLPERF SumOpenStmt(@NativeType(value="DWORD") int value) {
        SQLPERF.nSumOpenStmt(this.address(), value);
        return this;
    }

    public SQLPERF CurrentConnectionCount(@NativeType(value="DWORD") int value) {
        SQLPERF.nCurrentConnectionCount(this.address(), value);
        return this;
    }

    public SQLPERF MaxConnectionsOpened(@NativeType(value="DWORD") int value) {
        SQLPERF.nMaxConnectionsOpened(this.address(), value);
        return this;
    }

    public SQLPERF SumConnectionsOpened(@NativeType(value="DWORD") int value) {
        SQLPERF.nSumConnectionsOpened(this.address(), value);
        return this;
    }

    public SQLPERF SumConnectiontime(@NativeType(value="DWORD") int value) {
        SQLPERF.nSumConnectiontime(this.address(), value);
        return this;
    }

    public SQLPERF AvgTimeOpened(@NativeType(value="LDOUBLE") double value) {
        SQLPERF.nAvgTimeOpened(this.address(), value);
        return this;
    }

    public SQLPERF ServerRndTrips(@NativeType(value="DWORD") int value) {
        SQLPERF.nServerRndTrips(this.address(), value);
        return this;
    }

    public SQLPERF BuffersSent(@NativeType(value="DWORD") int value) {
        SQLPERF.nBuffersSent(this.address(), value);
        return this;
    }

    public SQLPERF BuffersRec(@NativeType(value="DWORD") int value) {
        SQLPERF.nBuffersRec(this.address(), value);
        return this;
    }

    public SQLPERF BytesSent(@NativeType(value="DWORD") int value) {
        SQLPERF.nBytesSent(this.address(), value);
        return this;
    }

    public SQLPERF BytesRec(@NativeType(value="DWORD") int value) {
        SQLPERF.nBytesRec(this.address(), value);
        return this;
    }

    public SQLPERF msExecutionTime(@NativeType(value="DWORD") int value) {
        SQLPERF.nmsExecutionTime(this.address(), value);
        return this;
    }

    public SQLPERF msNetWorkServerTime(@NativeType(value="DWORD") int value) {
        SQLPERF.nmsNetWorkServerTime(this.address(), value);
        return this;
    }

    public SQLPERF set(int TimerResolution, int SQLidu, int SQLiduRows, int SQLSelects, int SQLSelectRows, int Transactions, int SQLPrepares, int ExecDirects, int SQLExecutes, int CursorOpens, int CursorSize, int CursorUsed, double PercentCursorUsed, double AvgFetchTime, double AvgCursorSize, double AvgCursorUsed, int SQLFetchTime, int SQLFetchCount, int CurrentStmtCount, int MaxOpenStmt, int SumOpenStmt, int CurrentConnectionCount, int MaxConnectionsOpened, int SumConnectionsOpened, int SumConnectiontime, double AvgTimeOpened, int ServerRndTrips, int BuffersSent, int BuffersRec, int BytesSent, int BytesRec, int msExecutionTime, int msNetWorkServerTime) {
        this.TimerResolution(TimerResolution);
        this.SQLidu(SQLidu);
        this.SQLiduRows(SQLiduRows);
        this.SQLSelects(SQLSelects);
        this.SQLSelectRows(SQLSelectRows);
        this.Transactions(Transactions);
        this.SQLPrepares(SQLPrepares);
        this.ExecDirects(ExecDirects);
        this.SQLExecutes(SQLExecutes);
        this.CursorOpens(CursorOpens);
        this.CursorSize(CursorSize);
        this.CursorUsed(CursorUsed);
        this.PercentCursorUsed(PercentCursorUsed);
        this.AvgFetchTime(AvgFetchTime);
        this.AvgCursorSize(AvgCursorSize);
        this.AvgCursorUsed(AvgCursorUsed);
        this.SQLFetchTime(SQLFetchTime);
        this.SQLFetchCount(SQLFetchCount);
        this.CurrentStmtCount(CurrentStmtCount);
        this.MaxOpenStmt(MaxOpenStmt);
        this.SumOpenStmt(SumOpenStmt);
        this.CurrentConnectionCount(CurrentConnectionCount);
        this.MaxConnectionsOpened(MaxConnectionsOpened);
        this.SumConnectionsOpened(SumConnectionsOpened);
        this.SumConnectiontime(SumConnectiontime);
        this.AvgTimeOpened(AvgTimeOpened);
        this.ServerRndTrips(ServerRndTrips);
        this.BuffersSent(BuffersSent);
        this.BuffersRec(BuffersRec);
        this.BytesSent(BytesSent);
        this.BytesRec(BytesRec);
        this.msExecutionTime(msExecutionTime);
        this.msNetWorkServerTime(msNetWorkServerTime);
        return this;
    }

    public SQLPERF set(SQLPERF src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SQLPERF malloc() {
        return new SQLPERF(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SQLPERF calloc() {
        return new SQLPERF(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SQLPERF create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SQLPERF(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SQLPERF create(long address) {
        return new SQLPERF(address, null);
    }

    @Nullable
    public static SQLPERF createSafe(long address) {
        return address == 0L ? null : new SQLPERF(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SQLPERF.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SQLPERF.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static SQLPERF mallocStack() {
        return SQLPERF.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static SQLPERF callocStack() {
        return SQLPERF.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static SQLPERF mallocStack(MemoryStack stack) {
        return SQLPERF.malloc(stack);
    }

    @Deprecated
    public static SQLPERF callocStack(MemoryStack stack) {
        return SQLPERF.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return SQLPERF.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return SQLPERF.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return SQLPERF.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return SQLPERF.calloc(capacity, stack);
    }

    public static SQLPERF malloc(MemoryStack stack) {
        return new SQLPERF(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SQLPERF calloc(MemoryStack stack) {
        return new SQLPERF(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nTimerResolution(long struct) {
        return UNSAFE.getInt(null, struct + (long)TIMERRESOLUTION);
    }

    public static int nSQLidu(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLIDU);
    }

    public static int nSQLiduRows(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLIDUROWS);
    }

    public static int nSQLSelects(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLSELECTS);
    }

    public static int nSQLSelectRows(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLSELECTROWS);
    }

    public static int nTransactions(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSACTIONS);
    }

    public static int nSQLPrepares(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLPREPARES);
    }

    public static int nExecDirects(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXECDIRECTS);
    }

    public static int nSQLExecutes(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLEXECUTES);
    }

    public static int nCursorOpens(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSOROPENS);
    }

    public static int nCursorSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSORSIZE);
    }

    public static int nCursorUsed(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSORUSED);
    }

    public static double nPercentCursorUsed(long struct) {
        return UNSAFE.getDouble(null, struct + (long)PERCENTCURSORUSED);
    }

    public static double nAvgFetchTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)AVGFETCHTIME);
    }

    public static double nAvgCursorSize(long struct) {
        return UNSAFE.getDouble(null, struct + (long)AVGCURSORSIZE);
    }

    public static double nAvgCursorUsed(long struct) {
        return UNSAFE.getDouble(null, struct + (long)AVGCURSORUSED);
    }

    public static int nSQLFetchTime(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLFETCHTIME);
    }

    public static int nSQLFetchCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SQLFETCHCOUNT);
    }

    public static int nCurrentStmtCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTSTMTCOUNT);
    }

    public static int nMaxOpenStmt(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXOPENSTMT);
    }

    public static int nSumOpenStmt(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUMOPENSTMT);
    }

    public static int nCurrentConnectionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTCONNECTIONCOUNT);
    }

    public static int nMaxConnectionsOpened(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXCONNECTIONSOPENED);
    }

    public static int nSumConnectionsOpened(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUMCONNECTIONSOPENED);
    }

    public static int nSumConnectiontime(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUMCONNECTIONTIME);
    }

    public static double nAvgTimeOpened(long struct) {
        return UNSAFE.getDouble(null, struct + (long)AVGTIMEOPENED);
    }

    public static int nServerRndTrips(long struct) {
        return UNSAFE.getInt(null, struct + (long)SERVERRNDTRIPS);
    }

    public static int nBuffersSent(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERSSENT);
    }

    public static int nBuffersRec(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERSREC);
    }

    public static int nBytesSent(long struct) {
        return UNSAFE.getInt(null, struct + (long)BYTESSENT);
    }

    public static int nBytesRec(long struct) {
        return UNSAFE.getInt(null, struct + (long)BYTESREC);
    }

    public static int nmsExecutionTime(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSEXECUTIONTIME);
    }

    public static int nmsNetWorkServerTime(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSNETWORKSERVERTIME);
    }

    public static void nTimerResolution(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TIMERRESOLUTION, value);
    }

    public static void nSQLidu(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLIDU, value);
    }

    public static void nSQLiduRows(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLIDUROWS, value);
    }

    public static void nSQLSelects(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLSELECTS, value);
    }

    public static void nSQLSelectRows(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLSELECTROWS, value);
    }

    public static void nTransactions(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSACTIONS, value);
    }

    public static void nSQLPrepares(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLPREPARES, value);
    }

    public static void nExecDirects(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EXECDIRECTS, value);
    }

    public static void nSQLExecutes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLEXECUTES, value);
    }

    public static void nCursorOpens(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURSOROPENS, value);
    }

    public static void nCursorSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURSORSIZE, value);
    }

    public static void nCursorUsed(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURSORUSED, value);
    }

    public static void nPercentCursorUsed(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)PERCENTCURSORUSED, value);
    }

    public static void nAvgFetchTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)AVGFETCHTIME, value);
    }

    public static void nAvgCursorSize(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)AVGCURSORSIZE, value);
    }

    public static void nAvgCursorUsed(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)AVGCURSORUSED, value);
    }

    public static void nSQLFetchTime(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLFETCHTIME, value);
    }

    public static void nSQLFetchCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SQLFETCHCOUNT, value);
    }

    public static void nCurrentStmtCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURRENTSTMTCOUNT, value);
    }

    public static void nMaxOpenStmt(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXOPENSTMT, value);
    }

    public static void nSumOpenStmt(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUMOPENSTMT, value);
    }

    public static void nCurrentConnectionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURRENTCONNECTIONCOUNT, value);
    }

    public static void nMaxConnectionsOpened(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXCONNECTIONSOPENED, value);
    }

    public static void nSumConnectionsOpened(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUMCONNECTIONSOPENED, value);
    }

    public static void nSumConnectiontime(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUMCONNECTIONTIME, value);
    }

    public static void nAvgTimeOpened(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)AVGTIMEOPENED, value);
    }

    public static void nServerRndTrips(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SERVERRNDTRIPS, value);
    }

    public static void nBuffersSent(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERSSENT, value);
    }

    public static void nBuffersRec(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERSREC, value);
    }

    public static void nBytesSent(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BYTESSENT, value);
    }

    public static void nBytesRec(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BYTESREC, value);
    }

    public static void nmsExecutionTime(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSEXECUTIONTIME, value);
    }

    public static void nmsNetWorkServerTime(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSNETWORKSERVERTIME, value);
    }

    static {
        Struct.Layout layout = SQLPERF.__struct((Struct.Member[])new Struct.Member[]{SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)8), SQLPERF.__member((int)8), SQLPERF.__member((int)8), SQLPERF.__member((int)8), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)8), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4), SQLPERF.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TIMERRESOLUTION = layout.offsetof(0);
        SQLIDU = layout.offsetof(1);
        SQLIDUROWS = layout.offsetof(2);
        SQLSELECTS = layout.offsetof(3);
        SQLSELECTROWS = layout.offsetof(4);
        TRANSACTIONS = layout.offsetof(5);
        SQLPREPARES = layout.offsetof(6);
        EXECDIRECTS = layout.offsetof(7);
        SQLEXECUTES = layout.offsetof(8);
        CURSOROPENS = layout.offsetof(9);
        CURSORSIZE = layout.offsetof(10);
        CURSORUSED = layout.offsetof(11);
        PERCENTCURSORUSED = layout.offsetof(12);
        AVGFETCHTIME = layout.offsetof(13);
        AVGCURSORSIZE = layout.offsetof(14);
        AVGCURSORUSED = layout.offsetof(15);
        SQLFETCHTIME = layout.offsetof(16);
        SQLFETCHCOUNT = layout.offsetof(17);
        CURRENTSTMTCOUNT = layout.offsetof(18);
        MAXOPENSTMT = layout.offsetof(19);
        SUMOPENSTMT = layout.offsetof(20);
        CURRENTCONNECTIONCOUNT = layout.offsetof(21);
        MAXCONNECTIONSOPENED = layout.offsetof(22);
        SUMCONNECTIONSOPENED = layout.offsetof(23);
        SUMCONNECTIONTIME = layout.offsetof(24);
        AVGTIMEOPENED = layout.offsetof(25);
        SERVERRNDTRIPS = layout.offsetof(26);
        BUFFERSSENT = layout.offsetof(27);
        BUFFERSREC = layout.offsetof(28);
        BYTESSENT = layout.offsetof(29);
        BYTESREC = layout.offsetof(30);
        MSEXECUTIONTIME = layout.offsetof(31);
        MSNETWORKSERVERTIME = layout.offsetof(32);
    }

    public static class Buffer
    extends StructBuffer<SQLPERF, Buffer>
    implements NativeResource {
        private static final SQLPERF ELEMENT_FACTORY = SQLPERF.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SQLPERF getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="DWORD")
        public int TimerResolution() {
            return SQLPERF.nTimerResolution(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLidu() {
            return SQLPERF.nSQLidu(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLiduRows() {
            return SQLPERF.nSQLiduRows(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLSelects() {
            return SQLPERF.nSQLSelects(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLSelectRows() {
            return SQLPERF.nSQLSelectRows(this.address());
        }

        @NativeType(value="DWORD")
        public int Transactions() {
            return SQLPERF.nTransactions(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLPrepares() {
            return SQLPERF.nSQLPrepares(this.address());
        }

        @NativeType(value="DWORD")
        public int ExecDirects() {
            return SQLPERF.nExecDirects(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLExecutes() {
            return SQLPERF.nSQLExecutes(this.address());
        }

        @NativeType(value="DWORD")
        public int CursorOpens() {
            return SQLPERF.nCursorOpens(this.address());
        }

        @NativeType(value="DWORD")
        public int CursorSize() {
            return SQLPERF.nCursorSize(this.address());
        }

        @NativeType(value="DWORD")
        public int CursorUsed() {
            return SQLPERF.nCursorUsed(this.address());
        }

        @NativeType(value="LDOUBLE")
        public double PercentCursorUsed() {
            return SQLPERF.nPercentCursorUsed(this.address());
        }

        @NativeType(value="LDOUBLE")
        public double AvgFetchTime() {
            return SQLPERF.nAvgFetchTime(this.address());
        }

        @NativeType(value="LDOUBLE")
        public double AvgCursorSize() {
            return SQLPERF.nAvgCursorSize(this.address());
        }

        @NativeType(value="LDOUBLE")
        public double AvgCursorUsed() {
            return SQLPERF.nAvgCursorUsed(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLFetchTime() {
            return SQLPERF.nSQLFetchTime(this.address());
        }

        @NativeType(value="DWORD")
        public int SQLFetchCount() {
            return SQLPERF.nSQLFetchCount(this.address());
        }

        @NativeType(value="DWORD")
        public int CurrentStmtCount() {
            return SQLPERF.nCurrentStmtCount(this.address());
        }

        @NativeType(value="DWORD")
        public int MaxOpenStmt() {
            return SQLPERF.nMaxOpenStmt(this.address());
        }

        @NativeType(value="DWORD")
        public int SumOpenStmt() {
            return SQLPERF.nSumOpenStmt(this.address());
        }

        @NativeType(value="DWORD")
        public int CurrentConnectionCount() {
            return SQLPERF.nCurrentConnectionCount(this.address());
        }

        @NativeType(value="DWORD")
        public int MaxConnectionsOpened() {
            return SQLPERF.nMaxConnectionsOpened(this.address());
        }

        @NativeType(value="DWORD")
        public int SumConnectionsOpened() {
            return SQLPERF.nSumConnectionsOpened(this.address());
        }

        @NativeType(value="DWORD")
        public int SumConnectiontime() {
            return SQLPERF.nSumConnectiontime(this.address());
        }

        @NativeType(value="LDOUBLE")
        public double AvgTimeOpened() {
            return SQLPERF.nAvgTimeOpened(this.address());
        }

        @NativeType(value="DWORD")
        public int ServerRndTrips() {
            return SQLPERF.nServerRndTrips(this.address());
        }

        @NativeType(value="DWORD")
        public int BuffersSent() {
            return SQLPERF.nBuffersSent(this.address());
        }

        @NativeType(value="DWORD")
        public int BuffersRec() {
            return SQLPERF.nBuffersRec(this.address());
        }

        @NativeType(value="DWORD")
        public int BytesSent() {
            return SQLPERF.nBytesSent(this.address());
        }

        @NativeType(value="DWORD")
        public int BytesRec() {
            return SQLPERF.nBytesRec(this.address());
        }

        @NativeType(value="DWORD")
        public int msExecutionTime() {
            return SQLPERF.nmsExecutionTime(this.address());
        }

        @NativeType(value="DWORD")
        public int msNetWorkServerTime() {
            return SQLPERF.nmsNetWorkServerTime(this.address());
        }

        public Buffer TimerResolution(@NativeType(value="DWORD") int value) {
            SQLPERF.nTimerResolution(this.address(), value);
            return this;
        }

        public Buffer SQLidu(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLidu(this.address(), value);
            return this;
        }

        public Buffer SQLiduRows(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLiduRows(this.address(), value);
            return this;
        }

        public Buffer SQLSelects(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLSelects(this.address(), value);
            return this;
        }

        public Buffer SQLSelectRows(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLSelectRows(this.address(), value);
            return this;
        }

        public Buffer Transactions(@NativeType(value="DWORD") int value) {
            SQLPERF.nTransactions(this.address(), value);
            return this;
        }

        public Buffer SQLPrepares(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLPrepares(this.address(), value);
            return this;
        }

        public Buffer ExecDirects(@NativeType(value="DWORD") int value) {
            SQLPERF.nExecDirects(this.address(), value);
            return this;
        }

        public Buffer SQLExecutes(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLExecutes(this.address(), value);
            return this;
        }

        public Buffer CursorOpens(@NativeType(value="DWORD") int value) {
            SQLPERF.nCursorOpens(this.address(), value);
            return this;
        }

        public Buffer CursorSize(@NativeType(value="DWORD") int value) {
            SQLPERF.nCursorSize(this.address(), value);
            return this;
        }

        public Buffer CursorUsed(@NativeType(value="DWORD") int value) {
            SQLPERF.nCursorUsed(this.address(), value);
            return this;
        }

        public Buffer PercentCursorUsed(@NativeType(value="LDOUBLE") double value) {
            SQLPERF.nPercentCursorUsed(this.address(), value);
            return this;
        }

        public Buffer AvgFetchTime(@NativeType(value="LDOUBLE") double value) {
            SQLPERF.nAvgFetchTime(this.address(), value);
            return this;
        }

        public Buffer AvgCursorSize(@NativeType(value="LDOUBLE") double value) {
            SQLPERF.nAvgCursorSize(this.address(), value);
            return this;
        }

        public Buffer AvgCursorUsed(@NativeType(value="LDOUBLE") double value) {
            SQLPERF.nAvgCursorUsed(this.address(), value);
            return this;
        }

        public Buffer SQLFetchTime(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLFetchTime(this.address(), value);
            return this;
        }

        public Buffer SQLFetchCount(@NativeType(value="DWORD") int value) {
            SQLPERF.nSQLFetchCount(this.address(), value);
            return this;
        }

        public Buffer CurrentStmtCount(@NativeType(value="DWORD") int value) {
            SQLPERF.nCurrentStmtCount(this.address(), value);
            return this;
        }

        public Buffer MaxOpenStmt(@NativeType(value="DWORD") int value) {
            SQLPERF.nMaxOpenStmt(this.address(), value);
            return this;
        }

        public Buffer SumOpenStmt(@NativeType(value="DWORD") int value) {
            SQLPERF.nSumOpenStmt(this.address(), value);
            return this;
        }

        public Buffer CurrentConnectionCount(@NativeType(value="DWORD") int value) {
            SQLPERF.nCurrentConnectionCount(this.address(), value);
            return this;
        }

        public Buffer MaxConnectionsOpened(@NativeType(value="DWORD") int value) {
            SQLPERF.nMaxConnectionsOpened(this.address(), value);
            return this;
        }

        public Buffer SumConnectionsOpened(@NativeType(value="DWORD") int value) {
            SQLPERF.nSumConnectionsOpened(this.address(), value);
            return this;
        }

        public Buffer SumConnectiontime(@NativeType(value="DWORD") int value) {
            SQLPERF.nSumConnectiontime(this.address(), value);
            return this;
        }

        public Buffer AvgTimeOpened(@NativeType(value="LDOUBLE") double value) {
            SQLPERF.nAvgTimeOpened(this.address(), value);
            return this;
        }

        public Buffer ServerRndTrips(@NativeType(value="DWORD") int value) {
            SQLPERF.nServerRndTrips(this.address(), value);
            return this;
        }

        public Buffer BuffersSent(@NativeType(value="DWORD") int value) {
            SQLPERF.nBuffersSent(this.address(), value);
            return this;
        }

        public Buffer BuffersRec(@NativeType(value="DWORD") int value) {
            SQLPERF.nBuffersRec(this.address(), value);
            return this;
        }

        public Buffer BytesSent(@NativeType(value="DWORD") int value) {
            SQLPERF.nBytesSent(this.address(), value);
            return this;
        }

        public Buffer BytesRec(@NativeType(value="DWORD") int value) {
            SQLPERF.nBytesRec(this.address(), value);
            return this;
        }

        public Buffer msExecutionTime(@NativeType(value="DWORD") int value) {
            SQLPERF.nmsExecutionTime(this.address(), value);
            return this;
        }

        public Buffer msNetWorkServerTime(@NativeType(value="DWORD") int value) {
            SQLPERF.nmsNetWorkServerTime(this.address(), value);
            return this;
        }
    }
}

