/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_specialization_constant")
public class SpvcSpecializationConstant
extends Struct<SpvcSpecializationConstant>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int CONSTANT_ID;

    protected SpvcSpecializationConstant(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcSpecializationConstant create(long address, @Nullable ByteBuffer container) {
        return new SpvcSpecializationConstant(address, container);
    }

    public SpvcSpecializationConstant(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcSpecializationConstant.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_constant_id")
    public int id() {
        return SpvcSpecializationConstant.nid(this.address());
    }

    @NativeType(value="unsigned int")
    public int constant_id() {
        return SpvcSpecializationConstant.nconstant_id(this.address());
    }

    public SpvcSpecializationConstant id(@NativeType(value="spvc_constant_id") int value) {
        SpvcSpecializationConstant.nid(this.address(), value);
        return this;
    }

    public SpvcSpecializationConstant constant_id(@NativeType(value="unsigned int") int value) {
        SpvcSpecializationConstant.nconstant_id(this.address(), value);
        return this;
    }

    public SpvcSpecializationConstant set(int id, int constant_id) {
        this.id(id);
        this.constant_id(constant_id);
        return this;
    }

    public SpvcSpecializationConstant set(SpvcSpecializationConstant src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcSpecializationConstant malloc() {
        return new SpvcSpecializationConstant(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcSpecializationConstant calloc() {
        return new SpvcSpecializationConstant(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcSpecializationConstant create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcSpecializationConstant(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcSpecializationConstant create(long address) {
        return new SpvcSpecializationConstant(address, null);
    }

    @Nullable
    public static SpvcSpecializationConstant createSafe(long address) {
        return address == 0L ? null : new SpvcSpecializationConstant(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcSpecializationConstant.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcSpecializationConstant.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcSpecializationConstant malloc(MemoryStack stack) {
        return new SpvcSpecializationConstant(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcSpecializationConstant calloc(MemoryStack stack) {
        return new SpvcSpecializationConstant(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static int nconstant_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONSTANT_ID);
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    public static void nconstant_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONSTANT_ID, value);
    }

    static {
        Struct.Layout layout = SpvcSpecializationConstant.__struct((Struct.Member[])new Struct.Member[]{SpvcSpecializationConstant.__member((int)4), SpvcSpecializationConstant.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        CONSTANT_ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcSpecializationConstant, Buffer>
    implements NativeResource {
        private static final SpvcSpecializationConstant ELEMENT_FACTORY = SpvcSpecializationConstant.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcSpecializationConstant getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_constant_id")
        public int id() {
            return SpvcSpecializationConstant.nid(this.address());
        }

        @NativeType(value="unsigned int")
        public int constant_id() {
            return SpvcSpecializationConstant.nconstant_id(this.address());
        }

        public Buffer id(@NativeType(value="spvc_constant_id") int value) {
            SpvcSpecializationConstant.nid(this.address(), value);
            return this;
        }

        public Buffer constant_id(@NativeType(value="unsigned int") int value) {
            SpvcSpecializationConstant.nconstant_id(this.address(), value);
            return this;
        }
    }
}

