/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkChart;
import org.lwjgl.nuklear.NkCommandBuffer;
import org.lwjgl.nuklear.NkMenuState;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkRowLayout;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_panel")
public class NkPanel
extends Struct<NkPanel> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int BOUNDS;
    public static final int OFFSET_X;
    public static final int OFFSET_Y;
    public static final int AT_X;
    public static final int AT_Y;
    public static final int MAX_X;
    public static final int FOOTER_HEIGHT;
    public static final int HEADER_HEIGHT;
    public static final int BORDER;
    public static final int HAS_SCROLLING;
    public static final int CLIP;
    public static final int MENU;
    public static final int ROW;
    public static final int CHART;
    public static final int BUFFER;
    public static final int PARENT;

    protected NkPanel(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkPanel create(long address, @Nullable ByteBuffer container) {
        return new NkPanel(address, container);
    }

    public NkPanel(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkPanel.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum nk_panel_type")
    public int type() {
        return NkPanel.ntype(this.address());
    }

    @NativeType(value="nk_flags")
    public int flags() {
        return NkPanel.nflags(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect bounds() {
        return NkPanel.nbounds(this.address());
    }

    @NativeType(value="nk_uint *")
    public IntBuffer offset_x(int capacity) {
        return NkPanel.noffset_x(this.address(), capacity);
    }

    @NativeType(value="nk_uint *")
    public IntBuffer offset_y(int capacity) {
        return NkPanel.noffset_y(this.address(), capacity);
    }

    public float at_x() {
        return NkPanel.nat_x(this.address());
    }

    public float at_y() {
        return NkPanel.nat_y(this.address());
    }

    public float max_x() {
        return NkPanel.nmax_x(this.address());
    }

    public float footer_height() {
        return NkPanel.nfooter_height(this.address());
    }

    public float header_height() {
        return NkPanel.nheader_height(this.address());
    }

    public float border() {
        return NkPanel.nborder(this.address());
    }

    @NativeType(value="unsigned int")
    public int has_scrolling() {
        return NkPanel.nhas_scrolling(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect clip() {
        return NkPanel.nclip(this.address());
    }

    @NativeType(value="struct nk_menu_state")
    public NkMenuState menu() {
        return NkPanel.nmenu(this.address());
    }

    @NativeType(value="struct nk_row_layout")
    public NkRowLayout row() {
        return NkPanel.nrow(this.address());
    }

    @NativeType(value="struct nk_chart")
    public NkChart chart() {
        return NkPanel.nchart(this.address());
    }

    @NativeType(value="struct nk_command_buffer *")
    public NkCommandBuffer buffer() {
        return NkPanel.nbuffer(this.address());
    }

    @NativeType(value="struct nk_panel *")
    public NkPanel parent() {
        return NkPanel.nparent(this.address());
    }

    public static NkPanel create(long address) {
        return new NkPanel(address, null);
    }

    @Nullable
    public static NkPanel createSafe(long address) {
        return address == 0L ? null : new NkPanel(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static NkRect nbounds(long struct) {
        return NkRect.create(struct + (long)BOUNDS);
    }

    public static IntBuffer noffset_x(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)OFFSET_X)), (int)capacity);
    }

    public static IntBuffer noffset_y(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)OFFSET_Y)), (int)capacity);
    }

    public static float nat_x(long struct) {
        return UNSAFE.getFloat(null, struct + (long)AT_X);
    }

    public static float nat_y(long struct) {
        return UNSAFE.getFloat(null, struct + (long)AT_Y);
    }

    public static float nmax_x(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAX_X);
    }

    public static float nfooter_height(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FOOTER_HEIGHT);
    }

    public static float nheader_height(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEADER_HEIGHT);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static int nhas_scrolling(long struct) {
        return UNSAFE.getInt(null, struct + (long)HAS_SCROLLING);
    }

    public static NkRect nclip(long struct) {
        return NkRect.create(struct + (long)CLIP);
    }

    public static NkMenuState nmenu(long struct) {
        return NkMenuState.create(struct + (long)MENU);
    }

    public static NkRowLayout nrow(long struct) {
        return NkRowLayout.create(struct + (long)ROW);
    }

    public static NkChart nchart(long struct) {
        return NkChart.create(struct + (long)CHART);
    }

    public static NkCommandBuffer nbuffer(long struct) {
        return NkCommandBuffer.create(MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)));
    }

    public static NkPanel nparent(long struct) {
        return NkPanel.create(MemoryUtil.memGetAddress((long)(struct + (long)PARENT)));
    }

    static {
        Struct.Layout layout = NkPanel.__struct((Struct.Member[])new Struct.Member[]{NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)NkRect.SIZEOF, (int)NkRect.ALIGNOF), NkPanel.__member((int)POINTER_SIZE), NkPanel.__member((int)POINTER_SIZE), NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)4), NkPanel.__member((int)NkRect.SIZEOF, (int)NkRect.ALIGNOF), NkPanel.__member((int)NkMenuState.SIZEOF, (int)NkMenuState.ALIGNOF), NkPanel.__member((int)NkRowLayout.SIZEOF, (int)NkRowLayout.ALIGNOF), NkPanel.__member((int)NkChart.SIZEOF, (int)NkChart.ALIGNOF), NkPanel.__member((int)POINTER_SIZE), NkPanel.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        BOUNDS = layout.offsetof(2);
        OFFSET_X = layout.offsetof(3);
        OFFSET_Y = layout.offsetof(4);
        AT_X = layout.offsetof(5);
        AT_Y = layout.offsetof(6);
        MAX_X = layout.offsetof(7);
        FOOTER_HEIGHT = layout.offsetof(8);
        HEADER_HEIGHT = layout.offsetof(9);
        BORDER = layout.offsetof(10);
        HAS_SCROLLING = layout.offsetof(11);
        CLIP = layout.offsetof(12);
        MENU = layout.offsetof(13);
        ROW = layout.offsetof(14);
        CHART = layout.offsetof(15);
        BUFFER = layout.offsetof(16);
        PARENT = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<NkPanel, Buffer> {
        private static final NkPanel ELEMENT_FACTORY = NkPanel.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkPanel getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum nk_panel_type")
        public int type() {
            return NkPanel.ntype(this.address());
        }

        @NativeType(value="nk_flags")
        public int flags() {
            return NkPanel.nflags(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect bounds() {
            return NkPanel.nbounds(this.address());
        }

        @NativeType(value="nk_uint *")
        public IntBuffer offset_x(int capacity) {
            return NkPanel.noffset_x(this.address(), capacity);
        }

        @NativeType(value="nk_uint *")
        public IntBuffer offset_y(int capacity) {
            return NkPanel.noffset_y(this.address(), capacity);
        }

        public float at_x() {
            return NkPanel.nat_x(this.address());
        }

        public float at_y() {
            return NkPanel.nat_y(this.address());
        }

        public float max_x() {
            return NkPanel.nmax_x(this.address());
        }

        public float footer_height() {
            return NkPanel.nfooter_height(this.address());
        }

        public float header_height() {
            return NkPanel.nheader_height(this.address());
        }

        public float border() {
            return NkPanel.nborder(this.address());
        }

        @NativeType(value="unsigned int")
        public int has_scrolling() {
            return NkPanel.nhas_scrolling(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect clip() {
            return NkPanel.nclip(this.address());
        }

        @NativeType(value="struct nk_menu_state")
        public NkMenuState menu() {
            return NkPanel.nmenu(this.address());
        }

        @NativeType(value="struct nk_row_layout")
        public NkRowLayout row() {
            return NkPanel.nrow(this.address());
        }

        @NativeType(value="struct nk_chart")
        public NkChart chart() {
            return NkPanel.nchart(this.address());
        }

        @NativeType(value="struct nk_command_buffer *")
        public NkCommandBuffer buffer() {
            return NkPanel.nbuffer(this.address());
        }

        @NativeType(value="struct nk_panel *")
        public NkPanel parent() {
            return NkPanel.nparent(this.address());
        }
    }
}

