/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_user_font_glyph")
public class NkUserFontGlyph
extends Struct<NkUserFontGlyph>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UV;
    public static final int OFFSET;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int XADVANCE;

    protected NkUserFontGlyph(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkUserFontGlyph create(long address, @Nullable ByteBuffer container) {
        return new NkUserFontGlyph(address, container);
    }

    public NkUserFontGlyph(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkUserFontGlyph.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_vec2[2]")
    public NkVec2.Buffer uv() {
        return NkUserFontGlyph.nuv(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 uv(int index) {
        return NkUserFontGlyph.nuv(this.address(), index);
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 offset() {
        return NkUserFontGlyph.noffset(this.address());
    }

    public float width() {
        return NkUserFontGlyph.nwidth(this.address());
    }

    public float height() {
        return NkUserFontGlyph.nheight(this.address());
    }

    public float xadvance() {
        return NkUserFontGlyph.nxadvance(this.address());
    }

    public NkUserFontGlyph uv(@NativeType(value="struct nk_vec2[2]") NkVec2.Buffer value) {
        NkUserFontGlyph.nuv(this.address(), value);
        return this;
    }

    public NkUserFontGlyph uv(int index, @NativeType(value="struct nk_vec2") NkVec2 value) {
        NkUserFontGlyph.nuv(this.address(), index, value);
        return this;
    }

    public NkUserFontGlyph uv(Consumer<NkVec2.Buffer> consumer) {
        consumer.accept(this.uv());
        return this;
    }

    public NkUserFontGlyph uv(int index, Consumer<NkVec2> consumer) {
        consumer.accept(this.uv(index));
        return this;
    }

    public NkUserFontGlyph offset(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkUserFontGlyph.noffset(this.address(), value);
        return this;
    }

    public NkUserFontGlyph offset(Consumer<NkVec2> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public NkUserFontGlyph width(float value) {
        NkUserFontGlyph.nwidth(this.address(), value);
        return this;
    }

    public NkUserFontGlyph height(float value) {
        NkUserFontGlyph.nheight(this.address(), value);
        return this;
    }

    public NkUserFontGlyph xadvance(float value) {
        NkUserFontGlyph.nxadvance(this.address(), value);
        return this;
    }

    public NkUserFontGlyph set(NkVec2.Buffer uv, NkVec2 offset, float width, float height, float xadvance) {
        this.uv(uv);
        this.offset(offset);
        this.width(width);
        this.height(height);
        this.xadvance(xadvance);
        return this;
    }

    public NkUserFontGlyph set(NkUserFontGlyph src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkUserFontGlyph malloc() {
        return new NkUserFontGlyph(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkUserFontGlyph calloc() {
        return new NkUserFontGlyph(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkUserFontGlyph create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkUserFontGlyph(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkUserFontGlyph create(long address) {
        return new NkUserFontGlyph(address, null);
    }

    @Nullable
    public static NkUserFontGlyph createSafe(long address) {
        return address == 0L ? null : new NkUserFontGlyph(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkUserFontGlyph.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkUserFontGlyph.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkUserFontGlyph mallocStack() {
        return NkUserFontGlyph.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkUserFontGlyph callocStack() {
        return NkUserFontGlyph.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkUserFontGlyph mallocStack(MemoryStack stack) {
        return NkUserFontGlyph.malloc(stack);
    }

    @Deprecated
    public static NkUserFontGlyph callocStack(MemoryStack stack) {
        return NkUserFontGlyph.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkUserFontGlyph.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkUserFontGlyph.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.calloc(capacity, stack);
    }

    public static NkUserFontGlyph malloc(MemoryStack stack) {
        return new NkUserFontGlyph(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkUserFontGlyph calloc(MemoryStack stack) {
        return new NkUserFontGlyph(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkVec2.Buffer nuv(long struct) {
        return NkVec2.create(struct + (long)UV, 2);
    }

    public static NkVec2 nuv(long struct, int index) {
        return NkVec2.create(struct + (long)UV + Checks.check((int)index, (int)2) * (long)NkVec2.SIZEOF);
    }

    public static NkVec2 noffset(long struct) {
        return NkVec2.create(struct + (long)OFFSET);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float nxadvance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)XADVANCE);
    }

    public static void nuv(long struct, NkVec2.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)UV), (long)(value.remaining() * NkVec2.SIZEOF));
    }

    public static void nuv(long struct, int index, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)UV + Checks.check((int)index, (int)2) * (long)NkVec2.SIZEOF), (long)NkVec2.SIZEOF);
    }

    public static void noffset(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)NkVec2.SIZEOF);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void nxadvance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)XADVANCE, value);
    }

    static {
        Struct.Layout layout = NkUserFontGlyph.__struct((Struct.Member[])new Struct.Member[]{NkUserFontGlyph.__array((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF, (int)2), NkUserFontGlyph.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkUserFontGlyph.__member((int)4), NkUserFontGlyph.__member((int)4), NkUserFontGlyph.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UV = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        XADVANCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkUserFontGlyph, Buffer>
    implements NativeResource {
        private static final NkUserFontGlyph ELEMENT_FACTORY = NkUserFontGlyph.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkUserFontGlyph getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_vec2[2]")
        public NkVec2.Buffer uv() {
            return NkUserFontGlyph.nuv(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 uv(int index) {
            return NkUserFontGlyph.nuv(this.address(), index);
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 offset() {
            return NkUserFontGlyph.noffset(this.address());
        }

        public float width() {
            return NkUserFontGlyph.nwidth(this.address());
        }

        public float height() {
            return NkUserFontGlyph.nheight(this.address());
        }

        public float xadvance() {
            return NkUserFontGlyph.nxadvance(this.address());
        }

        public Buffer uv(@NativeType(value="struct nk_vec2[2]") NkVec2.Buffer value) {
            NkUserFontGlyph.nuv(this.address(), value);
            return this;
        }

        public Buffer uv(int index, @NativeType(value="struct nk_vec2") NkVec2 value) {
            NkUserFontGlyph.nuv(this.address(), index, value);
            return this;
        }

        public Buffer uv(Consumer<NkVec2.Buffer> consumer) {
            consumer.accept(this.uv());
            return this;
        }

        public Buffer uv(int index, Consumer<NkVec2> consumer) {
            consumer.accept(this.uv(index));
            return this;
        }

        public Buffer offset(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkUserFontGlyph.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<NkVec2> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer width(float value) {
            NkUserFontGlyph.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            NkUserFontGlyph.nheight(this.address(), value);
            return this;
        }

        public Buffer xadvance(float value) {
            NkUserFontGlyph.nxadvance(this.address(), value);
            return this;
        }
    }
}

