/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.msdfgen.LibMsdfGen;
import org.lwjgl.util.msdfgen.MSDFGenBitmap;
import org.lwjgl.util.msdfgen.MSDFGenBounds;
import org.lwjgl.util.msdfgen.MSDFGenConfig;
import org.lwjgl.util.msdfgen.MSDFGenMultichannelConfig;
import org.lwjgl.util.msdfgen.MSDFGenTransform;
import org.lwjgl.util.msdfgen.MSDFGenVector2;

public class MSDFGen {
    public static final int MSDF_FALSE = 0;
    public static final int MSDF_TRUE = 1;
    public static final int MSDF_SUCCESS = 0;
    public static final int MSDF_ERR_FAILED = 1;
    public static final int MSDF_ERR_INVALID_ARG = 2;
    public static final int MSDF_ERR_INVALID_TYPE = 3;
    public static final int MSDF_ERR_INVALID_SIZE = 4;
    public static final int MSDF_ERR_INVALID_INDEX = 5;
    public static final int MSDF_BITMAP_TYPE_SDF = 0;
    public static final int MSDF_BITMAP_TYPE_PSDF = 1;
    public static final int MSDF_BITMAP_TYPE_MSDF = 2;
    public static final int MSDF_BITMAP_TYPE_MTSDF = 3;
    public static final int MSDF_SEGMENT_TYPE_LINEAR = 0;
    public static final int MSDF_SEGMENT_TYPE_QUADRATIC = 1;
    public static final int MSDF_SEGMENT_TYPE_CUBIC = 2;
    public static final int MSDF_EDGE_COLOR_BLACK = 0;
    public static final int MSDF_EDGE_COLOR_RED = 1;
    public static final int MSDF_EDGE_COLOR_GREEN = 2;
    public static final int MSDF_EDGE_COLOR_YELLOW = 3;
    public static final int MSDF_EDGE_COLOR_BLUE = 4;
    public static final int MSDF_EDGE_COLOR_MAGENTA = 5;
    public static final int MSDF_EDGE_COLOR_CYAN = 6;
    public static final int MSDF_EDGE_COLOR_WHITE = 7;
    public static final int MSDF_ERROR_CORRECTION_MODE_DISABLED = 0;
    public static final int MSDF_ERROR_CORRECTION_MODE_INDISCRIMINATE = 1;
    public static final int MSDF_ERROR_CORRECTION_MODE_EDGE_PRIORITY = 2;
    public static final int MSDF_ERROR_CORRECTION_MODE_EDGE_ONLY = 3;
    public static final int MSDF_DISTANCE_CHECK_MODE_NONE = 0;
    public static final int MSDF_DISTANCE_CHECK_MODE_AT_EDGE = 1;
    public static final int MSDF_DISTANCE_CHECK_MODE_ALWAYS = 2;

    protected MSDFGen() {
        throw new UnsupportedOperationException();
    }

    public static native int nmsdf_bitmap_alloc(int var0, int var1, int var2, long var3);

    public static int msdf_bitmap_alloc(int type, int width, int height, @NativeType(value="struct msdf_bitmap *") MSDFGenBitmap bitmap) {
        return MSDFGen.nmsdf_bitmap_alloc(type, width, height, bitmap.address());
    }

    public static native int nmsdf_bitmap_get_channel_count(long var0, long var2);

    public static int msdf_bitmap_get_channel_count(@NativeType(value="struct msdf_bitmap const *") MSDFGenBitmap bitmap, @NativeType(value="int *") IntBuffer channel_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)channel_count, (int)1);
            MSDFGenBitmap.validate(bitmap.address());
        }
        return MSDFGen.nmsdf_bitmap_get_channel_count(bitmap.address(), MemoryUtil.memAddress((IntBuffer)channel_count));
    }

    public static native int nmsdf_bitmap_get_pixels(long var0, long var2);

    public static int msdf_bitmap_get_pixels(@NativeType(value="struct msdf_bitmap const *") MSDFGenBitmap bitmap, @NativeType(value="void **") PointerBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pixels, (int)1);
            MSDFGenBitmap.validate(bitmap.address());
        }
        return MSDFGen.nmsdf_bitmap_get_pixels(bitmap.address(), MemoryUtil.memAddress((CustomBuffer)pixels));
    }

    public static native int nmsdf_bitmap_get_byte_size(long var0, long var2);

    public static int msdf_bitmap_get_byte_size(@NativeType(value="struct msdf_bitmap const *") MSDFGenBitmap bitmap, @NativeType(value="size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)size, (int)1);
            MSDFGenBitmap.validate(bitmap.address());
        }
        return MSDFGen.nmsdf_bitmap_get_byte_size(bitmap.address(), MemoryUtil.memAddress((CustomBuffer)size));
    }

    public static native void nmsdf_bitmap_free(long var0);

    public static void msdf_bitmap_free(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap bitmap) {
        MSDFGen.nmsdf_bitmap_free(bitmap.address());
    }

    public static native int nmsdf_shape_alloc(long var0);

    public static int msdf_shape_alloc(@NativeType(value="msdf_shape_handle *") PointerBuffer shape) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)shape, (int)1);
        }
        return MSDFGen.nmsdf_shape_alloc(MemoryUtil.memAddress((CustomBuffer)shape));
    }

    public static native int nmsdf_shape_get_bounds(long var0, long var2);

    public static int msdf_shape_get_bounds(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_bounds *") MSDFGenBounds bounds) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_get_bounds(shape, bounds.address());
    }

    public static native int nmsdf_shape_add_contour(long var0, long var2);

    public static int msdf_shape_add_contour(@NativeType(value="msdf_shape_handle") long shape, @NativeType(value="msdf_contour_const_handle *") PointerBuffer contour) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((CustomBuffer)contour, (int)1);
        }
        return MSDFGen.nmsdf_shape_add_contour(shape, MemoryUtil.memAddress((CustomBuffer)contour));
    }

    public static native int nmsdf_shape_remove_contour(long var0, long var2);

    public static int msdf_shape_remove_contour(@NativeType(value="msdf_shape_handle") long shape, @NativeType(value="msdf_contour_const_handle") long contour) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((long)contour);
        }
        return MSDFGen.nmsdf_shape_remove_contour(shape, contour);
    }

    public static native int nmsdf_shape_get_contour_count(long var0, long var2);

    public static int msdf_shape_get_contour_count(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((CustomBuffer)size, (int)1);
        }
        return MSDFGen.nmsdf_shape_get_contour_count(shape, MemoryUtil.memAddress((CustomBuffer)size));
    }

    public static native int nmsdf_shape_get_contour(long var0, long var2, long var4);

    public static int msdf_shape_get_contour(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="size_t") long index, @NativeType(value="msdf_contour_const_handle *") PointerBuffer contour) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((CustomBuffer)contour, (int)1);
        }
        return MSDFGen.nmsdf_shape_get_contour(shape, index, MemoryUtil.memAddress((CustomBuffer)contour));
    }

    public static native int nmsdf_shape_get_edge_count(long var0, long var2);

    public static int msdf_shape_get_edge_count(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="size_t *") PointerBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((CustomBuffer)count, (int)1);
        }
        return MSDFGen.nmsdf_shape_get_edge_count(shape, MemoryUtil.memAddress((CustomBuffer)count));
    }

    public static native int nmsdf_shape_has_inverse_y_axis(long var0, long var2);

    public static int msdf_shape_has_inverse_y_axis(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="int *") IntBuffer inverse_y_axis) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((Buffer)inverse_y_axis, (int)1);
        }
        return MSDFGen.nmsdf_shape_has_inverse_y_axis(shape, MemoryUtil.memAddress((IntBuffer)inverse_y_axis));
    }

    public static native int nmsdf_shape_normalize(long var0);

    public static int msdf_shape_normalize(@NativeType(value="msdf_shape_handle") long shape) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_normalize(shape);
    }

    public static native int nmsdf_shape_validate(long var0, long var2);

    public static int msdf_shape_validate(@NativeType(value="msdf_shape_handle") long shape, @NativeType(value="int *") IntBuffer result) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((Buffer)result, (int)1);
        }
        return MSDFGen.nmsdf_shape_validate(shape, MemoryUtil.memAddress((IntBuffer)result));
    }

    public static native int nmsdf_shape_bound(long var0, long var2);

    public static int msdf_shape_bound(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_bounds *") MSDFGenBounds bounds) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_bound(shape, bounds.address());
    }

    public static native int nmsdf_shape_bound_miters(long var0, long var2, double var4, double var6, int var8);

    public static int msdf_shape_bound_miters(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_bounds *") MSDFGenBounds bounds, double border, double miter_limit, int polarity) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_bound_miters(shape, bounds.address(), border, miter_limit, polarity);
    }

    public static native int nmsdf_shape_orient_contours(long var0);

    public static int msdf_shape_orient_contours(@NativeType(value="msdf_shape_handle") long shape) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_orient_contours(shape);
    }

    public static native int nmsdf_shape_edge_colors_simple(long var0, double var2);

    public static int msdf_shape_edge_colors_simple(@NativeType(value="msdf_shape_handle") long shape, double angle_threshold) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_edge_colors_simple(shape, angle_threshold);
    }

    public static native int nmsdf_shape_edge_colors_ink_trap(long var0, double var2);

    public static int msdf_shape_edge_colors_ink_trap(@NativeType(value="msdf_shape_handle") long shape, double angle_threshold) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_edge_colors_ink_trap(shape, angle_threshold);
    }

    public static native int nmsdf_shape_edge_colors_by_distance(long var0, double var2);

    public static int msdf_shape_edge_colors_by_distance(@NativeType(value="msdf_shape_handle") long shape, double angle_threshold) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_shape_edge_colors_by_distance(shape, angle_threshold);
    }

    public static native int nmsdf_shape_one_shot_distance(long var0, long var2, long var4);

    public static int msdf_shape_one_shot_distance(@NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_vector2 const *") MSDFGenVector2 origin, @NativeType(value="double *") DoubleBuffer distance) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
            Checks.check((Buffer)distance, (int)1);
        }
        return MSDFGen.nmsdf_shape_one_shot_distance(shape, origin.address(), MemoryUtil.memAddress((DoubleBuffer)distance));
    }

    public static native void nmsdf_shape_free(long var0);

    public static void msdf_shape_free(@NativeType(value="msdf_shape_handle") long shape) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        MSDFGen.nmsdf_shape_free(shape);
    }

    public static native int nmsdf_contour_alloc(long var0);

    public static int msdf_contour_alloc(@NativeType(value="msdf_contour_handle *") PointerBuffer contour) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)contour, (int)1);
        }
        return MSDFGen.nmsdf_contour_alloc(MemoryUtil.memAddress((CustomBuffer)contour));
    }

    public static native int nmsdf_contour_add_edge(long var0, long var2);

    public static int msdf_contour_add_edge(@NativeType(value="msdf_contour_handle") long contour, @NativeType(value="msdf_segment_handle") long segment) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_contour_add_edge(contour, segment);
    }

    public static native int nmsdf_contour_remove_edge(long var0, long var2);

    public static int msdf_contour_remove_edge(@NativeType(value="msdf_contour_handle") long contour, @NativeType(value="msdf_segment_handle") long segment) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_contour_remove_edge(contour, segment);
    }

    public static native int nmsdf_contour_get_edge_count(long var0, long var2);

    public static int msdf_contour_get_edge_count(@NativeType(value="msdf_contour_const_handle") long contour, @NativeType(value="size_t *") PointerBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
            Checks.check((CustomBuffer)count, (int)1);
        }
        return MSDFGen.nmsdf_contour_get_edge_count(contour, MemoryUtil.memAddress((CustomBuffer)count));
    }

    public static native int nmsdf_contour_get_edge(long var0, long var2, long var4);

    public static int msdf_contour_get_edge(@NativeType(value="msdf_contour_const_handle") long contour, @NativeType(value="size_t") long index, @NativeType(value="msdf_segment_const_handle *") PointerBuffer segment) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
            Checks.check((CustomBuffer)segment, (int)1);
        }
        return MSDFGen.nmsdf_contour_get_edge(contour, index, MemoryUtil.memAddress((CustomBuffer)segment));
    }

    public static native int nmsdf_contour_bound(long var0, long var2);

    public static int msdf_contour_bound(@NativeType(value="msdf_contour_const_handle") long contour, @NativeType(value="struct msdf_bounds *") MSDFGenBounds bounds) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
        }
        return MSDFGen.nmsdf_contour_bound(contour, bounds.address());
    }

    public static native int nmsdf_contour_bound_miters(long var0, long var2, double var4, double var6, int var8);

    public static int msdf_contour_bound_miters(@NativeType(value="msdf_contour_const_handle") long contour, @NativeType(value="struct msdf_bounds *") MSDFGenBounds bounds, double border, double miter_limit, int polarity) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
        }
        return MSDFGen.nmsdf_contour_bound_miters(contour, bounds.address(), border, miter_limit, polarity);
    }

    public static native int nmsdf_contour_get_winding(long var0, long var2);

    public static int msdf_contour_get_winding(@NativeType(value="msdf_contour_const_handle") long contour, @NativeType(value="int *") IntBuffer winding) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
            Checks.check((Buffer)winding, (int)1);
        }
        return MSDFGen.nmsdf_contour_get_winding(contour, MemoryUtil.memAddress((IntBuffer)winding));
    }

    public static native int nmsdf_contour_reverse(long var0);

    public static int msdf_contour_reverse(@NativeType(value="msdf_contour_handle") long contour) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
        }
        return MSDFGen.nmsdf_contour_reverse(contour);
    }

    public static native void nmsdf_contour_free(long var0);

    public static void msdf_contour_free(@NativeType(value="msdf_contour_handle") long contour) {
        if (Checks.CHECKS) {
            Checks.check((long)contour);
        }
        MSDFGen.nmsdf_contour_free(contour);
    }

    public static native int nmsdf_segment_alloc(int var0, long var1);

    public static int msdf_segment_alloc(int type, @NativeType(value="msdf_segment_handle *") PointerBuffer segment) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)segment, (int)1);
        }
        return MSDFGen.nmsdf_segment_alloc(type, MemoryUtil.memAddress((CustomBuffer)segment));
    }

    public static native int nmsdf_segment_get_type(long var0, long var2);

    public static int msdf_segment_get_type(@NativeType(value="msdf_segment_const_handle") long segment, @NativeType(value="int *") IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
            Checks.check((Buffer)type, (int)1);
        }
        return MSDFGen.nmsdf_segment_get_type(segment, MemoryUtil.memAddress((IntBuffer)type));
    }

    public static native int nmsdf_segment_get_point_count(long var0, long var2);

    public static int msdf_segment_get_point_count(@NativeType(value="msdf_segment_const_handle") long segment, @NativeType(value="size_t *") PointerBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
            Checks.check((CustomBuffer)count, (int)1);
        }
        return MSDFGen.nmsdf_segment_get_point_count(segment, MemoryUtil.memAddress((CustomBuffer)count));
    }

    public static native int nmsdf_segment_get_point(long var0, long var2, long var4);

    public static int msdf_segment_get_point(@NativeType(value="msdf_segment_const_handle") long segment, @NativeType(value="size_t") long index, @NativeType(value="struct msdf_vector2 *") MSDFGenVector2 point) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_get_point(segment, index, point.address());
    }

    public static native int nmsdf_segment_set_point(long var0, long var2, long var4);

    public static int msdf_segment_set_point(@NativeType(value="msdf_segment_handle") long segment, @NativeType(value="size_t") long index, @NativeType(value="struct msdf_vector2 const *") MSDFGenVector2 point) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_set_point(segment, index, point.address());
    }

    public static native int nmsdf_segment_get_color(long var0, long var2);

    public static int msdf_segment_get_color(@NativeType(value="msdf_segment_const_handle") long segment, @NativeType(value="int *") IntBuffer color) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
            Checks.check((Buffer)color, (int)1);
        }
        return MSDFGen.nmsdf_segment_get_color(segment, MemoryUtil.memAddress((IntBuffer)color));
    }

    public static native int nmsdf_segment_set_color(long var0, int var2);

    public static int msdf_segment_set_color(@NativeType(value="msdf_segment_handle") long segment, int color) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_set_color(segment, color);
    }

    public static native int nmsdf_segment_get_direction(long var0, double var2, long var4);

    public static int msdf_segment_get_direction(@NativeType(value="msdf_segment_const_handle") long segment, double param, @NativeType(value="struct msdf_vector2 *") MSDFGenVector2 direction) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_get_direction(segment, param, direction.address());
    }

    public static native int nmsdf_segment_get_direction_change(long var0, double var2, long var4);

    public static int msdf_segment_get_direction_change(@NativeType(value="msdf_segment_const_handle") long segment, double param, @NativeType(value="struct msdf_vector2 *") MSDFGenVector2 direction_change) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_get_direction_change(segment, param, direction_change.address());
    }

    public static native int nmsdf_segment_point(long var0, double var2, long var4);

    public static int msdf_segment_point(@NativeType(value="msdf_segment_const_handle") long segment, double param, @NativeType(value="struct msdf_vector2 *") MSDFGenVector2 point) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_point(segment, param, point.address());
    }

    public static native int nmsdf_segment_bound(long var0, long var2);

    public static int msdf_segment_bound(@NativeType(value="msdf_segment_const_handle") long segment, @NativeType(value="struct msdf_bounds *") MSDFGenBounds bounds) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_bound(segment, bounds.address());
    }

    public static native int nmsdf_segment_move_start_point(long var0, long var2);

    public static int msdf_segment_move_start_point(@NativeType(value="msdf_segment_handle") long segment, @NativeType(value="struct msdf_vector2 const *") MSDFGenVector2 point) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_move_start_point(segment, point.address());
    }

    public static native int nmsdf_segment_move_end_point(long var0, long var2);

    public static int msdf_segment_move_end_point(@NativeType(value="msdf_segment_handle") long segment, @NativeType(value="struct msdf_vector2 const *") MSDFGenVector2 point) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        return MSDFGen.nmsdf_segment_move_end_point(segment, point.address());
    }

    public static native void nmsdf_segment_free(long var0);

    public static void msdf_segment_free(@NativeType(value="msdf_segment_handle") long segment) {
        if (Checks.CHECKS) {
            Checks.check((long)segment);
        }
        MSDFGen.nmsdf_segment_free(segment);
    }

    public static native int nmsdf_generate_sdf(long var0, long var2, long var4);

    public static int msdf_generate_sdf(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_sdf(output.address(), shape, transform.address());
    }

    public static native int nmsdf_generate_psdf(long var0, long var2, long var4);

    public static int msdf_generate_psdf(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_psdf(output.address(), shape, transform.address());
    }

    public static native int nmsdf_generate_msdf(long var0, long var2, long var4);

    public static int msdf_generate_msdf(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_msdf(output.address(), shape, transform.address());
    }

    public static native int nmsdf_generate_mtsdf(long var0, long var2, long var4);

    public static int msdf_generate_mtsdf(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_mtsdf(output.address(), shape, transform.address());
    }

    public static native int nmsdf_generate_sdf_with_config(long var0, long var2, long var4, long var6);

    public static int msdf_generate_sdf_with_config(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform, @NativeType(value="struct msdf_config const *") MSDFGenConfig config) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_sdf_with_config(output.address(), shape, transform.address(), config.address());
    }

    public static native int nmsdf_generate_psdf_with_config(long var0, long var2, long var4, long var6);

    public static int msdf_generate_psdf_with_config(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform, @NativeType(value="struct msdf_config const *") MSDFGenConfig config) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_psdf_with_config(output.address(), shape, transform.address(), config.address());
    }

    public static native int nmsdf_generate_msdf_with_config(long var0, long var2, long var4, long var6);

    public static int msdf_generate_msdf_with_config(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform, @NativeType(value="struct msdf_multichannel_config const *") MSDFGenMultichannelConfig config) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_msdf_with_config(output.address(), shape, transform.address(), config.address());
    }

    public static native int nmsdf_generate_mtsdf_with_config(long var0, long var2, long var4, long var6);

    public static int msdf_generate_mtsdf_with_config(@NativeType(value="struct msdf_bitmap *") MSDFGenBitmap output, @NativeType(value="msdf_shape_const_handle") long shape, @NativeType(value="struct msdf_transform const *") MSDFGenTransform transform, @NativeType(value="struct msdf_multichannel_config const *") MSDFGenMultichannelConfig config) {
        if (Checks.CHECKS) {
            Checks.check((long)shape);
        }
        return MSDFGen.nmsdf_generate_mtsdf_with_config(output.address(), shape, transform.address(), config.address());
    }

    static {
        LibMsdfGen.initialize();
    }
}

