/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct msdf_bounds")
public class MSDFGenBounds
extends Struct<MSDFGenBounds>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int L;
    public static final int B;
    public static final int R;
    public static final int T;

    protected MSDFGenBounds(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MSDFGenBounds create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenBounds(address, container);
    }

    public MSDFGenBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MSDFGenBounds.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double l() {
        return MSDFGenBounds.nl(this.address());
    }

    public double b() {
        return MSDFGenBounds.nb(this.address());
    }

    public double r() {
        return MSDFGenBounds.nr(this.address());
    }

    public double t() {
        return MSDFGenBounds.nt(this.address());
    }

    public MSDFGenBounds l(double value) {
        MSDFGenBounds.nl(this.address(), value);
        return this;
    }

    public MSDFGenBounds b(double value) {
        MSDFGenBounds.nb(this.address(), value);
        return this;
    }

    public MSDFGenBounds r(double value) {
        MSDFGenBounds.nr(this.address(), value);
        return this;
    }

    public MSDFGenBounds t(double value) {
        MSDFGenBounds.nt(this.address(), value);
        return this;
    }

    public MSDFGenBounds set(double l, double b, double r, double t) {
        this.l(l);
        this.b(b);
        this.r(r);
        this.t(t);
        return this;
    }

    public MSDFGenBounds set(MSDFGenBounds src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static MSDFGenBounds malloc() {
        return new MSDFGenBounds(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MSDFGenBounds calloc() {
        return new MSDFGenBounds(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MSDFGenBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MSDFGenBounds(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MSDFGenBounds create(long address) {
        return new MSDFGenBounds(address, null);
    }

    @Nullable
    public static MSDFGenBounds createSafe(long address) {
        return address == 0L ? null : new MSDFGenBounds(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MSDFGenBounds.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenBounds.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenBounds malloc(MemoryStack stack) {
        return new MSDFGenBounds(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenBounds calloc(MemoryStack stack) {
        return new MSDFGenBounds(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nl(long struct) {
        return UNSAFE.getDouble(null, struct + (long)L);
    }

    public static double nb(long struct) {
        return UNSAFE.getDouble(null, struct + (long)B);
    }

    public static double nr(long struct) {
        return UNSAFE.getDouble(null, struct + (long)R);
    }

    public static double nt(long struct) {
        return UNSAFE.getDouble(null, struct + (long)T);
    }

    public static void nl(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)L, value);
    }

    public static void nb(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)B, value);
    }

    public static void nr(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)R, value);
    }

    public static void nt(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)T, value);
    }

    static {
        Struct.Layout layout = MSDFGenBounds.__struct((Struct.Member[])new Struct.Member[]{MSDFGenBounds.__member((int)8), MSDFGenBounds.__member((int)8), MSDFGenBounds.__member((int)8), MSDFGenBounds.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        L = layout.offsetof(0);
        B = layout.offsetof(1);
        R = layout.offsetof(2);
        T = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenBounds, Buffer>
    implements NativeResource {
        private static final MSDFGenBounds ELEMENT_FACTORY = MSDFGenBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MSDFGenBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double l() {
            return MSDFGenBounds.nl(this.address());
        }

        public double b() {
            return MSDFGenBounds.nb(this.address());
        }

        public double r() {
            return MSDFGenBounds.nr(this.address());
        }

        public double t() {
            return MSDFGenBounds.nt(this.address());
        }

        public Buffer l(double value) {
            MSDFGenBounds.nl(this.address(), value);
            return this;
        }

        public Buffer b(double value) {
            MSDFGenBounds.nb(this.address(), value);
            return this;
        }

        public Buffer r(double value) {
            MSDFGenBounds.nr(this.address(), value);
            return this;
        }

        public Buffer t(double value) {
            MSDFGenBounds.nt(this.address(), value);
            return this;
        }
    }
}

