/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct msdf_config")
public class MSDFGenConfig
extends Struct<MSDFGenConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAP_SUPPORT;

    protected MSDFGenConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MSDFGenConfig create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenConfig(address, container);
    }

    public MSDFGenConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MSDFGenConfig.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int overlap_support() {
        return MSDFGenConfig.noverlap_support(this.address());
    }

    public MSDFGenConfig overlap_support(int value) {
        MSDFGenConfig.noverlap_support(this.address(), value);
        return this;
    }

    public MSDFGenConfig set(MSDFGenConfig src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static MSDFGenConfig malloc() {
        return new MSDFGenConfig(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MSDFGenConfig calloc() {
        return new MSDFGenConfig(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MSDFGenConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MSDFGenConfig(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MSDFGenConfig create(long address) {
        return new MSDFGenConfig(address, null);
    }

    @Nullable
    public static MSDFGenConfig createSafe(long address) {
        return address == 0L ? null : new MSDFGenConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MSDFGenConfig.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenConfig.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenConfig malloc(MemoryStack stack) {
        return new MSDFGenConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenConfig calloc(MemoryStack stack) {
        return new MSDFGenConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int noverlap_support(long struct) {
        return UNSAFE.getInt(null, struct + (long)OVERLAP_SUPPORT);
    }

    public static void noverlap_support(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OVERLAP_SUPPORT, value);
    }

    static {
        Struct.Layout layout = MSDFGenConfig.__struct((Struct.Member[])new Struct.Member[]{MSDFGenConfig.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAP_SUPPORT = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenConfig, Buffer>
    implements NativeResource {
        private static final MSDFGenConfig ELEMENT_FACTORY = MSDFGenConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MSDFGenConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int overlap_support() {
            return MSDFGenConfig.noverlap_support(this.address());
        }

        public Buffer overlap_support(int value) {
            MSDFGenConfig.noverlap_support(this.address(), value);
            return this;
        }
    }
}

